---
name: feishu-folder-summary
description: Extract summaries from all documents in a Feishu folder. Use when the user needs to recursively scan a Feishu wiki space or drive folder, read all documents and sub-documents, and generate a comprehensive summary report in Markdown format. Triggers on requests like "extract summaries from Feishu folder", "generate document summary report", "recursively scan Feishu documents", or when given a feishu.cn/wiki/ or feishu.cn/drive/ URL.
---

# Feishu Folder Summary

This skill extracts summaries from all documents in a Feishu folder (wiki or drive), recursively scanning sub-folders and generating a comprehensive Markdown report.

## Overview

The skill performs the following operations:
1. Parses the Feishu folder URL to extract space_id and node_token
2. Recursively traverses the folder structure using feishu_wiki API
3. Reads each document's content using feishu_doc API
4. Generates structured summaries for each document
5. Compiles a comprehensive Markdown report with:
   - Complete directory tree
   - Document summaries organized by folder
   - Statistics and status overview
   - Links to original documents

## Supported URL Formats

- **Wiki folders**: `https://{domain}.feishu.cn/wiki/{node_token}`
- **Drive folders**: `https://{domain}.feishu.cn/drive/folder/{folder_token}`

## Workflow

### Step 1: Extract Folder Information

Parse the provided Feishu URL to identify:
- Document type (wiki or drive)
- Space ID (for wiki)
- Node token or folder token

### Step 2: Recursive Traversal

Use `feishu_wiki` API to traverse the folder structure:

```
feishu_wiki action="get" token="{node_token}"         # Get folder info
feishu_wiki action="nodes" space_id="{space_id}"      # List child nodes
```

For folders with `has_child: true`, recursively process child nodes.

### Step 3: Document Reading

For each document node, read its content:

```
feishu_doc action="read" doc_token="{obj_token}"
```

### Step 4: Generate Summary

Extract from each document:
- **Title**: Document title
- **Type**: Document or Folder
- **Status**: Complete, In Progress, or Empty
- **Core Content**: Key points, main topics, important information
- **Child Documents**: If folder, list contained documents

### Step 5: Compile Report

Generate a Markdown report with:
1. Header (source URL, generation time, document count)
2. Directory tree visualization
3. Hierarchical summaries (by folder level)
4. Statistics table
5. Related links

## Output Format

The generated report includes:

```markdown
# {Folder Name} Document Summary Report

**Source:** {URL}  
**Generated:** {Timestamp}  
**Total Documents:** {Count}

---

## Directory Structure

{Tree visualization}

---

## Level 1 Summaries

### 1. {Document Name}
- **Type:** {docx/folder}
- **Status:** {Complete/In Progress/Empty}
- **Summary:** {Core content description}

### 2. {Folder Name}/
- **Type:** folder
- **Documents:** {Count}
- **Summary:** {Folder description}

#### 2.1 {Child Document}
- **Type:** docx
- **Summary:** {Content summary}

---

## Statistics

| Category | Count | Status |
|----------|-------|--------|
| Total | X | - |
| Complete | X | ✅ |
| In Progress | X | 🚧 |
| Empty | X | ⚠️ |

---

*Report generated by feishu-folder-summary skill*
```

## Example Usage

**User Request:**
> "Extract summaries from https://caz6yhvgk5z.feishu.cn/wiki/BzslwD3Nei1Dggkvin5cV2hDnob"

**Skill Execution:**
1. Parse URL → Wiki folder, node_token=BzslwD3Nei1Dggkvin5cV2hDnob
2. Get folder info → space_id=7593876306731732193, title="AI云平台"
3. Recursively traverse → Found 14 level-1 nodes, 30+ child documents
4. Read each document → Extract content and generate summaries
5. Compile report → Generate comprehensive Markdown summary

**Output:**
- Complete directory tree
- Hierarchical summaries for all 44 documents
- Status tracking (✅ Complete, 🚧 In Progress, ⚠️ Empty)
- Statistics overview

## Key Considerations

- **Recursive Depth**: Process all levels of nested folders
- **Document Types**: Handle docx (documents) and folder (containers)
- **Error Handling**: Continue processing if individual document read fails
- **Content Length**: Generate concise but informative summaries
- **Status Detection**: Identify empty or placeholder documents
- **Token Efficiency**: Summarize long documents appropriately

## API Reference

See [references/feishu_api.md](references/feishu_api.md) for detailed API documentation.
