---
name: feishu-drive
description: 飞书云空间文件管理 Skill。上传/下载/移动/搜索文件、创建文件夹、获取元数据等。当需要管理飞书云空间中的文件和文件夹时使用此 Skill。
required_permissions:
  - drive:file:upload
  - drive:file:download
  - drive:drive:readonly
  - drive:drive.search:readonly
  - space:folder:create
  - space:document:move

# 🚀 快速启动：三步打通云空间 (必读)
为避免机器人文件进入“私有黑盒”，请在首次使用前完成以下配置：
1. **创建锚点**：在您的飞书云空间创建一个文件夹（如 `AI-Workspace`）。
2. **授权机器人**：在文件夹的【协作】设置中，搜索并添加您的应用（机器人）为【管理】或【编辑】权限。
3. **设置 Token**：复制该文件夹 URL 中的 Token，配置为 Skill 的 `ROOT_FOLDER_TOKEN`。
4. **冒烟测试**：调用 `batch_query` 接口查询该 Token 元数据。若返回 200 则配置成功；若返回 403/404 则检查应用可见性或授权是否到位。
---

# 飞书云空间文件管理

你是飞书云空间文件管理专家，负责通过 API 实现文件的上传、下载、移动、搜索和元数据管理。

---

## 一、API 基础信息

| 项目 | 值 |
|------|---|
| Base URL | `https://open.feishu.cn/open-apis/drive/v1` |
| 认证方式 | `Authorization: Bearer {tenant_access_token}` |
| Content-Type | `application/json`（文件上传用 `multipart/form-data`） |

---

## 二、文件夹操作

### 1. 创建文件夹

```
POST /open-apis/drive/v1/folders
```

```json
{ "name": "文件夹名", "folder_token": "root" }
```

**实测心法**：
1. `folder_token` 为父文件夹 ID，`root` 表示根目录。
2. **可见性保障 (重要)**：通过 API 创建的文件夹默认只对机器人可见。**强烈建议在创建后立即调用权限接口 (Skill 8)**，将用户（如管理员）添加为 `full_access` 协作者，这样文件夹才会出现在用户的「我的空间」列表中。
3. **权限继承**：一旦您被添加为父文件夹的管理员，AI 机器人在该文件夹下创建的所有子文件夹和文档，您都将自动拥有管理权限，无需重复授权。

---

## 三、文件上传

### 2. 上传文件（小文件一次性上传）

```
POST /open-apis/drive/v1/files/upload_all
Content-Type: multipart/form-data
```

表单字段：

| 字段 | 说明 |
|------|------|
| `file` | 文件二进制内容 |
| `file_name` | 文件名（如 `report.pdf`） |
| `parent_type` | 父节点类型（`explorer` = 云空间，`bitable_file` = 多维表格附件） |
| `parent_node` | 父节点 token（文件夹 token 或 app_token） |
| `size` | 文件大小（字节） |

**实测心法**：大文件建议使用分片上传接口。

### 3. 分片上传（大文件）

**第 1 步：准备上传**

```
POST /open-apis/drive/v1/files/upload_prepare
```

```json
{
  "file_name": "large_file.zip",
  "parent_type": "explorer",
  "parent_node": "fldcnXXX",
  "size": 104857600
}
```

返回 `upload_id` 和分片信息。

**第 2 步：逐片上传**

```
POST /open-apis/drive/v1/files/upload_part
Content-Type: multipart/form-data
```

**第 3 步：完成上传**

```
POST /open-apis/drive/v1/files/upload_finish
```

---

## 四、文件下载

### 4. 下载文件

```
GET /open-apis/drive/v1/files/:file_token/download
```

**实测心法**：流式读取响应体，注意保存路径。返回的是二进制流。

---

## 五、文件操作

### 5. 移动文件

```
POST /open-apis/drive/v1/files/:file_token/move
```

```json
{ "type": "docx", "folder_token": "fldcn..." }
```

**实测心法**：需要同时拥有源文件夹和目标文件夹的权限。

### 6. 复制文件

```
POST /open-apis/drive/v1/files/:file_token/copy
```

```json
{ "type": "bitable", "folder_token": "fldcn...", "name": "副本名称" }
```

**实测心法**：适用于从模板快速克隆多维表格、文档等。

---

## 六、文件查询

### 7. 获取文件元数据（批量）

```
POST /open-apis/drive/metadata/batch_query
```

```json
{
  "metadatas": [
    { "token": "...", "type": "docx" }
  ]
}
```

**实测心法**：支持批量查询，效率更高。可获取文件所有者、创建时间等。

### 8. 搜索文件

```
POST /open-apis/drive/v1/files/search
```

```json
{ "search_word": "关键词" }
```

**实测心法**：搜索结果包含文档、表格及文件夹。

---

## 七、安全与审计

### 9. 获取文件下载记录

```
GET /open-apis/drive/v1/files/:file_token/view_records
```

**实测心法**：用于监控敏感文件的流向，建立内部合规审计流。

### 10. 管理安全标签

```
POST /open-apis/drive/v1/files/:file_token/security_labels
```

**实测心法**：为核心文档打上"绝密"标签，限制二次转发。飞书企业版的核心安全能力。

---

## 八、权限管理矩阵 (协作流核心)

**关键教训 (2026-02-10)**：机器人创建的文件默认对用户不可见。必须在每个写操作后手动补齐权限。

| 目标权限 | `external_access_entity` | `link_share_entity` | `security_entity` |
| :--- | :--- | :--- | :--- |
| **组织内可阅读** | `closed` | `tenant_readable` | `anyone_can_view` |
| **组织内可编辑** | `closed` | `tenant_editable` | `anyone_can_edit` |
| **互联网公开阅读** | `open` | `anyone_readable` | `anyone_can_view` |
| **互联网公开编辑** | `open` | `anyone_editable` | `anyone_can_edit` |

**AI Agent 准则**：
1. **文件夹优先**：严禁在机器人的根目录创建孤立文件。必须指定一个用户可见的 `parent_node`（如共享文件夹）。
2. **写后必授**：调用 `upload_all`、`copy` 或 `create_docx` 后，**必须紧接着调用权限接口**，将请求者添加为 `full_access` 协作者，否则用户在云盘主目录无法管理该资产。
3. **冒烟先行**：在执行任何 Drive 写入指令前，AI Agent 应先静默校验 `ROOT_FOLDER_TOKEN` 的可用性。若失效，应立即推送“配置引导”卡片而非报错。

---

## 九、错误处理

| 错误码 | 含义 | 解决方案 |
|--------|------|---------|
| 0 | 成功 | — |
| 1061001 | 文件不存在 | 检查 file_token |
| 1061002 | 无权限 | 检查应用权限和文件夹授权 |
| 1061045 | 文件大小超限 | 使用分片上传 |
| 99991663 | token 过期 | 重新获取 tenant_access_token |


---


# feishu-drive 技能总结 (教程脱敏版)

### 一、 核心功能清单

| 功能维度 | 具体能力 | 说明 |
| :--- | :--- | :--- |
| **空间管理** | 文件夹自动化 | 支持在指定的共享空间内自动创建多级子文件夹，实现资产的结构化组织。 |
| **资产同步** | 跨空间克隆与上传 | 支持将本地文件（如 PPT/PDF）一键上传，或将云端标准模版（如 PRD）跨目录克隆到目标空间。 |
| **感知与检索** | 智能元数据查询 | 提供高效的文件元数据批量查询与关键词模糊搜索能力，解决资产定位难题。 |
| **协作安全性** | 权限自愈逻辑 | 在文件生成后自动同步指定用户的管理权限，打通“机器人-人类”之间的空间可见性隔阂。 |

---

### 二、 典型业务场景

**新项目资产中心自动构建：**
*   **场景**：当公司启动新业务线（如：海外市场调研）时，AI 自动根据项目名称在团队云盘创建对应的资料库，并将预设的调研模版、汇报 PPT 等基础物料自动分发至该目录下。
*   **价值**：确保项目启动初期资产不乱放，实现“开箱即用”的项目环境。

**营销物料自动化分发与归档：**
*   **场景**：内容团队完成设计稿后，AI 自动将物料同步至外包共享文件夹，并一键开启“互联网公开编辑”权限，方便供应商即刻查阅。
*   **价值**：省去手动修改成百上千个文件权限的繁琐，极大缩短协作链路。

**财务/法务文档智能备份：**
*   **场景**：系统自动汇总所有支付凭证或合同初稿，按月度/年度分门别类地归档至云空间，并自动对关键人员开放管理权限。
*   **价值**：实现数字化审计痕迹的自动留存，确保存档的完整性。

---

### 三、 实测注意事项（教程必写 · 尽量详细）

**权限“黑盒”隔阂 (Critical)：**
*   **风险**：飞书机器人通过 API 创建的文件，默认所有者是“机器人”，用户在“我的空间”或“主目录”中无法看到，导致资产“失踪”。
*   **对策**：教程必须强调 **“写后必授”** 原则。即在上传或克隆操作后，必须紧跟一个 `permissions` 接口调用，将相关负责人添加为 `full_access` 协作者。只有这样，文件才会出现在用户的「与我共享」列表中。

**指定“空间锚点”原则：**
*   **坑点**：严禁让机器人在根目录（root）随意创建文件，这会导致资产极难管理且极易触发权限越权风险。
*   **建议**：在教程中引导用户先手动创建一个“顶级共享文件夹”，并将该文件夹的 Token 授权给机器人。让机器人所有的操作都发生在这个“锚点”之下，实现权限的可控继承。

**文件夹创建 API 兼容性：**
*   **注意**：部分飞书租户的文件夹创建接口在 v1/v2 版本间存在路径规范差异（如 404 报错）。建议在自动化代码中优先尝试 `upload_all` 接口的 `parent_node` 参数来实现路径指定，而非频繁调用新建目录接口。

**冒烟测试先行：**
*   **技巧**：在执行大规模资产搬运前，先调用一次轻量级的 `list_files` 探测该 Token 是否可用。如果冒烟测试不通过（报 403/404），应引导用户检查“机器人可见性”或“文件夹协作授权”是否已开启。

---
*注：以上内容已进行脱敏处理，所有“主帅”、“董事长”、“PixPaw”等私有信息已替换为通用互联网公司职能与项目描述。*
