import os
import sys
from feishu_docx_client import FeishuDocx

def main():
    app_id = "cli_a92c5076b7789cd2"
    app_secret = "9jPdCn49G54RFoEoDPUCVcptnWZnTZqp"
    
    title = "# 📋 拍摄清单：剩汤圆拯救计划"
    content = """# 📋 拍摄清单：剩汤圆拯救计划

视频标题: 元宵节剩下的汤圆别冻冰箱了！3 种神仙吃法，比煮着好吃 10 倍！
视频时长: 35-40 秒
拍摄日期: _______________
拍摄人: _______________
发布平台: 抖音 / 快手 / 小红书 / B 站

---

## 🛒 一、食材采购清单

| 物品 | 数量 | 备注 | 购买状态 |
|------|------|------|---------|
| 汤圆（芝麻馅） | 1 袋 | 用于炸汤圆流心效果 | □ |
| 汤圆（花生馅） | 1 袋 | 用于煎汤圆流心效果 | □ |
| 汤圆（肉松馅） | 1 袋 | 用于烤汤圆流心效果 | □ |
| 食用油 | 1 瓶 | 家用即可 | □ |
| 备用汤圆 | 2 袋 | 防止翻车重来 | □ |

预算: 约 30-50 元

---

## 🔧 二、工具准备清单

### 厨房工具

| 物品 | 用途 | 检查状态 |
|------|------|---------|
| 空气炸锅 | 炸汤圆 + 烤汤圆 | □ 已清洁 □ 可用 |
| 平底锅（不粘） | 煎汤圆 | □ 已清洁 □ 可用 |
| 烤箱（可选） | 烤汤圆（可用空气炸锅代替） | □ 已清洁 □ 可用 |
| 锡纸盘 | 盛放汤圆（3 个） | □ 数量充足 |
| 保鲜袋 | 装汤圆裹油 | □ 数量充足 |
| 竹签 | 扎孔防爆炸 | □ 数量充足 |
| 油刷 | 烤汤圆刷油 | □ 已清洁 |
| 筷子/夹子 | 翻面、夹取 | □ 数量充足 |
| 厨房纸 | 擦油渍、清洁 | □ 数量充足 |

### 拍摄设备

| 物品 | 用途 | 检查状态 |
|------|------|---------|
| 手机 | 拍摄 | □ 电量充足 □ 存储空间足够 |
| 手机支架 | 俯拍 + 平视固定 | □ 稳固 □ 高度可调 |
| 补光灯×2 | 食物打光 | □ 电量充足 □ 亮度可调 |
| 收音麦克风 | 旁白录音 | □ 电量充足 □ 测试正常 |
| 三脚架（可选） | 固定机位 | □ 稳固 |

### 道具

| 物品 | 用途 | 检查状态 |
|------|------|---------|
| 透明手套 | 手部出镜 | □ 3 双 |
| 白色盘子 | 成品展示 | □ 3 个 |
| 冰箱 | 开头镜头 | □ 已清理 □ 有冻汤圆 |

---

## 📝 三、分镜头拍摄清单

### 镜头 1：冰箱开场（0-3 秒）
- [ ] 打开冰箱冷冻层
- [ ] 展示一堆冻汤圆
- [ ] 旁白："元宵节剩下的汤圆，是不是还冻在冰箱里？"
- [ ] 拍摄要点: 真实感，不要摆拍太整齐
- [ ] 重拍备用: □ 需要

### 镜头 2：3 种成品快切（3-6 秒）
- [ ] 炸汤圆成品特写
- [ ] 煎汤圆成品特写
- [ ] 烤汤圆成品特写
- [ ] 快速切换（每帧 0.5 秒）
- [ ] 旁白："3 种神仙吃法，比煮着好吃 10 倍！"
- [ ] 拍摄要点: 每种成品都要掰开展示流心
- [ ] 重拍备用: □ 需要

---

### 镜头 3：吃法 1 - 炸汤圆（6-14 秒，8 秒）

| 步骤 | 画面 | 旁白 | 检查项 |
|------|------|------|--------|
| 3.1 | 汤圆装进保鲜袋 | "第一种，空气炸锅炸汤圆" | □ |
| 3.2 | 往袋子里倒油 | "裹油" | □ |
| 3.3 | 摇晃袋子 | "让每个汤圆裹上油" | □ |
| 3.4 | 倒入锡纸盘 | "倒入锡纸盘" | □ |
| 3.5 | 慢放**竹签扎孔 | "关键！每个汤圆扎两个孔" | □ 特写清晰 |
| 3.6 | 放入空气炸锅 | "180 度 11 分钟" | □ |
| 3.7 | 成品拉出 | "外酥里嫩！" | □ |

**拍摄要点:
- [ ] 扎孔动作要慢，确保用户看清
- [ ] 空气炸锅温度/时间要显示清楚
- [ ] 成品要金黄酥脆

---

### 镜头 4：吃法 2 - 煎汤圆（14-22 秒，8 秒）

| 步骤 | 画面 | 旁白 | 检查项 |
|------|------|------|--------|
| 4.1 | 平底锅倒少量油 | "第二种，平底锅煎汤圆" | □ |
| 4.2 | 汤圆下锅 | "少油小火" | □ |
| 4.3 | 煎至底部金黄 | "每面 3 分钟" | □ |
| 4.4 | 翻面 | "外脆内软" | □ |
| 4.5 | 成品装盘 | "还不费油！" | □ |

拍摄要点:
- [ ] 油不要多，突出"少油健康"
- [ ] 翻面时展示底部金黄色
- [ ] 煎炸声要录清楚（"滋滋"声）

---

### 镜头 5：吃法 3 - 烤汤圆（22-30 秒，8 秒）

| 步骤 | 画面 | 旁白 | 检查项 |
|------|------|------|--------|
| 5.1 | 锡纸盘摆汤圆 | "第三种，烤箱烤汤圆" | □ |
| 5.2 | 用油刷刷油 | "刷层油" | □ |
| 5.3 | 放入烤箱/空气炸锅 | "200 度 15 分钟" | □ |
| 5.4 | 成品取出 | "跟烤串一样香！" | □ |

拍摄要点:
- [ ] 刷油动作要清晰
- [ ] 烤箱温度/时间显示清楚
- [ ] 成品表面要有焦黄色

---

### 镜头 6：3 种成品对比（30-35 秒，5 秒）
- [ ] 3 盘成品摆一起
- [ ] 挨个掰开展示流心
- [ ] 旁白："看这流心！炸的酥、煎的脆、烤的香，你最喜欢哪种？"
- [ ] 拍摄要点: 流心要明显，三种馅料区分开
- [ ] 重拍备用: □ 需要

### 镜头 7：结尾 CTA（35-38 秒，3 秒）
- [ ] 对着镜头举汤圆
- [ ] 旁白："评论区告诉我！我是 XX，剩汤圆不浪费～"
- [ ] 字幕："关注我，不浪费"
- [ ] 拍摄要点: 笑容自然，语气亲切
- [ ] 重拍备用: □ 需要

---

## 🎵 四、音频准备清单

### BGM
- [ ] 选择：抖音热门美食 BGM / 轻快电子音乐
- [ ] 音量：30%（不压旁白）
- [ ] 格式：MP3
- [ ] 版权：确认无版权风险

### 音效

| 音效 | 使用位置 | 音量 | 状态 |
|------|---------|------|------|
| 冰箱开门声 | 0 秒 | 50% | □ |
| "叮"转场声 | 3 秒、14 秒、22 秒 | 60% | □ |
| 扎孔"戳戳"声 | 10 秒 | 70% | □ |
| 煎炸"滋滋"声 | 17 秒 | 50% | □ |
| 烤箱/出锅"叮"声 | 28 秒、35 秒 | 60% | □ |

### 旁白录音
- [ ] 环境安静（关闭空调、窗户）
- [ ] 麦克风测试正常
- [ ] 语速：中等偏快（匹配 BGM 节奏）
- [ ] 语气：亲切、有活力
- [ ] 备用：每条旁白录 2-3 遍选最佳

---

## ✂️ 五、后期剪辑清单

### 字幕样式
- [ ] 标题：顶部中央，白色粗体 + 黑色描边
- [ ] 步骤序号：左上角，①②③，彩色圆圈背景
- [ ] 参数：画面下方，黄色高亮（如"180°C 11 分钟"）
- [ ] 重点提示：红色字体 + 放大（如"记得扎孔！"）

### 转场设计
- [ ] 开头→吃法 1：快速缩放转场
- [ ] 吃法 1→2→3："叮"声 + 硬切
- [ ] 结尾：淡出

### 调色参数
饱和度：+15%
暖色调：+10%
对比度：+5%
高光：-10%（防止过曝）
阴影：+5%（提升细节）

### 导出设置

| 参数 | 设置 |
|------|------|
| 分辨率 | 1080×1920（9:16 竖屏） |
| 帧率 | 30 fps |
| 码率 | 8-10 Mbps |
| 格式 | MP4 |
| 文件大小 | <50 MB |

---

## 📊 六、发布准备清单

### 标题（3 选 1）
- [ ] 主选: "元宵节剩下的汤圆别冻冰箱了！3 种神仙吃法，比煮着好吃 10 倍！"
- [ ] 备选 1: "我家剩汤圆的 3 种消灭方式，第 2 种最好吃！"
- [ ] 备选 2: "汤圆别再煮了！炸/煎/烤大比拼，你站哪种？"

### 标签
#剩汤圆 #元宵节 #空气炸锅美食 #汤圆的神仙吃法 #美食教程 #不浪费 #厨房小妙招

### 封面图
- [ ] 选择：3 种成品摆一起的照片
- [ ] 文字：大字"3 种神仙吃法"
- [ ] 色调：暖色调，高饱和度

### 发布时间
- [ ] 最佳: 周五 19:00-21:00
- [ ] 次选: 周六/周日 11:00-13:00
- [ ] 避开: 周一 - 周四工作日

### 评论区运营
- [ ] 发布后立刻发第 1 条："第 2 种煎汤圆我最爱，少油健康！你们呢？"
- [ ] 前 30 分钟回复前 10 条评论
- [ ] 1 小时后挑 3 个问题评论详细回复
- [ ] 24 小时后置顶高赞评论

---

## ⚠️ 七、风险检查清单

### 拍摄前检查
- [ ] 汤圆是否解冻合适（太硬不好操作，太软容易破）
- [ ] 空气炸锅/烤箱是否清洁干净
- [ ] 手机存储空间是否充足（至少 5GB）
- [ ] 补光灯电量是否充足
- [ ] 麦克风是否正常工作

### 拍摄中注意
- [ ] 每种做法先测试 1 次再正式拍
- [ ] 扎孔动作一定要拍清楚（可重拍）
- [ ] 成品流心要明显（选对馅料）
- [ ] 旁白录音环境安静

### 拍摄后检查
- [ ] 所有镜头是否拍完（对照分镜头清单）
- [ ] 是否有备用镜头（防止剪辑时发现不能用）
- [ ] 音频文件是否保存
- [ ] 原始素材是否备份

---

## 📋 八、时间规划

| 阶段 | 预计耗时 | 实际耗时 | 完成状态 |
|------|---------|---------|---------|
| 采购食材 | 30 分钟 | | □ |
| 准备工具 | 15 分钟 | | □ |
| 测试做法 | 30 分钟 | | □ |
| 正式拍摄 | 30 分钟 | | □ |
| 后期剪辑 | 40 分钟 | | □ |
| 发布运营 | 20 分钟 | | □ |
| 总计 | 约 2.5 小时 | | □ |

计划拍摄日期: _______________
计划发布日期: _______________

---

## 📞 九、紧急联系人

| 角色 | 姓名 | 联系方式 |
|------|------|---------|
| 拍摄 | | |
| 后期 | | |
| 发布 | | |

---
清单打印: 建议打印 2 份，一份拍摄现场用，一份后期剪辑用
清单更新: 根据实际情况勾选并备注
创建日期: 2026-03-03
创建人: 老魏
SOP 版本: v2.0"""

    folder_token = "CicIfQH2VlKqV0dBK4mceVMRnqf"
    
    client = FeishuDocx(app_id, app_secret)
    try:
        doc_id = client.create_document(title, folder_token=folder_token)
        print(f"Created document in folder: {doc_id}")
        client.append_markdown(doc_id, content)
        print("Successfully written content.")
    except Exception as e:
        print(f"Error: {e}")
        sys.exit(1)

if __name__ == "__main__":
    main()
