---
name: feishu-docs
description: 飞书文档管理工具，支持读取、创建、更新、删除飞书文档，导入本地文件为飞书文档，以及列出文件夹内容。用于在 Claude Code 中管理飞书云文档。
license: MIT
metadata:
  author: feishu-docs
  version: "1.0.0"
  openclaw:
     requires:
        env:
           - FEISHU_APP_ID
           - FEISHU_APP_SECRET
        bins:
           - node
     homepage: https://github.com/upupc/feishu-docs
---

# Feishu Docs Skill

用于管理飞书云文档的 CLI 工具封装 skill。

## 功能

- **get** - 读取飞书文档内容（支持 JSON/Markdown/Text 格式）
- **get-blocks** - 获取文档块结构化数据
- **create** - 创建新文档（支持从文件导入内容）
- **import-file** - 将本地文件导入为飞书文档（支持 txt, docx, xlsx, csv, md 等）
- **list** - 列出文件夹内容
- **delete** - 删除文档
- **update** - 更新文档内容（覆盖或追加模式）

## 环境配置

需要在 `.env` 文件中配置以下环境变量：

```
FEISHU_APP_ID=cli_xxxxxxxxxx
FEISHU_APP_SECRET=xxxxxxxxxx
FEISHU_DOMAIN=https://open.feishu.cn
```

### 获取应用凭证

1. 访问 https://open.feishu.cn/app
2. 创建企业自建应用
3. 在"凭证与基础信息"中获取 App ID 和 App Secret
4. 在"权限管理"中添加以下权限：
   - `docx:document` - 查看、编辑、创建文档
   - `drive:drive` - 查看、删除云空间文件
   - `drive:file` - 上传文件
   - `drive:importTask` - 导入文件为文档
   - `auth:tenant` - 获取租户访问凭证

## 使用方式

### 读取文档

```bash
# 读取文档内容（JSON 格式）
node scripts/index.js get -d doccxxxxxxxxxxxxxx

# 读取并保存为 Markdown
node scripts/index.js get -d doccxxxxxxxxxxxxxx -o output.md --format markdown

# 获取文档块结构
node scripts/index.js get-blocks -d doccxxxxxxxxxxxxxx -o blocks.json
```

### 创建文档

```bash
# 创建空文档
node scripts/index.js create -f foldxxxxxxxxxxxxxx -t "我的文档"

# 从文件创建文档（自动转换 Markdown）
node scripts/index.js create -f foldxxxxxxxxxxxxxx -t "我的文档" --file content.md
```

### 导入本地文件

```bash
# 导入 Markdown 文件为飞书文档
node scripts/index.js import-file -f ./document.md --folder-token foldxxxxxxxxxxxxxx --type docx --ext md

# 导入为表格
node scripts/index.js import-file -f ./data.csv --folder-token foldxxxxxxxxxxxxxx --type sheet --ext csv
```

### 列出文件夹

```bash
# 列出根目录
node scripts/index.js list

# 列出指定文件夹
node scripts/index.js list --folder-token foldxxxxxxxxxxxxxx
```

### 更新文档

```bash
# 覆盖文档内容
node scripts/index.js update -d doccxxxxxxxxxxxxxx --file new-content.md

# 追加内容
node scripts/index.js update -d doccxxxxxxxxxxxxxx --content "追加的文本" --append
```

### 删除文档

```bash
# 删除文档（需要 --force 确认）
node scripts/index.js delete -d doccxxxxxxxxxxxxxx --force
```

## 注意事项

1. 所有命令都需要先配置 `.env` 文件中的环境变量
2. 文档 token 以 `docc` 开头，文件夹 token 以 `fold` 开头
3. 导入大文件时需要等待转换完成，脚本会自动轮询任务状态
4. 创建文档时，文档信息会保存到 `doc-{documentId}.json` 文件中
