# feishu-doc-long-content

> 飞书文档长内容写入实战经验，解决 content 超长截断问题

## 问题背景

飞书文档工具 `feishu_doc` 的 `write` / `create` action 对单次 `content` 长度有限制（约 1KB），超出后会：
- 直接返回 400 错误
- 或部分写入后截断（显示空白）

## 核心要点

### 1. create 只是创建空白文档

```json
{
  "action": "create",
  "title": "新文档"
}
```
返回 `doc_id`，但文档内容是空的。

### 2. 必须用 write 写入内容

```json
{
  "action": "write",
  "doc_token": "ABC123",
  "content": "# 标题\n内容..."
}
```

### 3. content 必须控制在 1KB 以内

经验值：
- **< 800 字节**：安全写入
- **800-1500 字节**：可能失败
- **> 1500 字节**：基本失败

### 4. 长内容解决方案

**方案A：拆分章节**
将内容拆成多个小文档，每个 < 800 字节：
```
文档1：第1-2章
文档2：第3-4章
文档3：第5-6章
文档4：第7-8章
```

**方案B：多次 append**
创建文档后，分多次 append（但 append 也有累积限制）

**方案C：先存本地文件**
将内容写入本地 md 文件，让用户自己查看或转换

## 正确流程

```json
// 1. 创建文档
{ "action": "create", "title": "笔记 Ch1" }
// → { "doc_id": "ABC123", "url": "..." }

// 2. 写入内容（控制 < 800 字节）
{ "action": "write", "doc_token": "ABC123", "content": "精简版内容..." }

// 3. 验证
{ "action": "read", "doc_token": "ABC123" }
```

## 常见错误

| 错误表现 | 原因 | 解决方案 |
|---------|------|---------|
| 文档创建后空白 | create 后没写 content | 用 write 写入 |
| write 返回成功但内容截断 | content 超过 1KB | 拆分内容 |
| write 返回 400 错误 | content 过长 | 精简内容或拆分 |

## 判断内容长度

在写入前估算：
- 纯文本：约 1 字符 = 1 字节
- Markdown：约 1 字符 = 1 字节（含格式符）
- 经验：800 字符约等于 800 字节（中文英文混合时略大）

## 最佳实践

1. **先在本地写 md 文件**，确认内容完整
2. **写入飞书前精简**，移除冗余格式和重复内容
3. **分章节输出**，每章一个文档
4. **写入后立即验证**，用 read 检查 block_count

---

*经验来源：2026-02-25 初级会计实务笔记输出实战*
