---
name: feishu-deep-research
description: 飞书深度研究报告生成器。自动执行深度研究并将结果导入为飞书文档。输入研究主题和云空间文件夹token，自动生成结构化研究报告并上传到飞书云空间。用于投资研究、行业分析、竞品调研、技术调研等需要多步骤信息收集和文档化的场景。
---

# Feishu Deep Research

自动执行深度研究并生成飞书文档的完整工作流。

> ⚠️ **重要技术约束**
> 
> 本技能要求 **严格使用飞书 REST API 直接调用**，禁止使用任何封装工具（如 `feishu_doc`、`feishu_drive` 等）。
> 
> **原因**：封装工具隐藏了关键步骤（token获取、文件上传、导入任务），无法验证流程合规性。
> 
> **必须使用**：`exec` 工具 + `curl` 命令直接调用飞书 API

## Usage

```
/feishu-research "研究主题" --folder-token <parent_node>
```

## 执行流程

完整的端到端工作流包含三个阶段：

### Phase 0: 启动确认（唯一交互点）

**必须首先向用户确认：**

```
【启动确认】

研究主题：{topic}
研究深度：{basic/standard/deep}
数据时效：默认覆盖至 {current_date}
搜索速率：默认 1次/秒

请确认或调整：
- 如需指定历史日期范围，请告诉我（例："只需2024年数据"）
- 如需调整搜索速率，请告诉我（例："2次/秒"或"不限"）
- 如无特殊要求，回复"确认"开始执行
```

**规则：**
- 用户无回复 → 等待（不自动开始）
- 用户回复"确认" → 按默认值执行（数据覆盖至current_date，1次/秒）
- 用户指定日期 → 按用户要求的时间范围执行
- 用户指定速率 → 按用户指定的速率执行

### Phase 1: 深度研究（全自动）

确认后**全自动执行**，不再交互。

#### 1.1 前置检查

- **读取当前日期**：确定数据时效目标
- **验证时间范围**：
  - 用户指定日期 → 按用户要求
  - 用户未指定 → 默认覆盖至 current_date
- **验证搜索API可用性**：如不可用，立即停止并报告

#### 1.2 搜索策略（按时间分层）

| 轮次 | 目标 | 时间范围 | 来源要求 |
|------|------|----------|----------|
| 第一轮 | 历史基础数据 | 最近完整财年 | 覆盖核心指标 |
| 第二轮 | 近期表现 | 最近4个季度 | 季度财报/数据 |
| 第三轮 | 最新动态 | 当前年份至current_date | 必须包含当月数据 |

**搜索速率控制：**
- 默认：1次/秒（每次搜索间隔1秒）
- 用户指定：按用户要求执行

**硬性规则：**
- 必须包含当年数据（如今天是2026年，必须有2026年数据）
- 必须覆盖到 current_date - 1个月 以内
- 来源数必须达到深度要求：Basic≥5, Standard≥10, Deep≥20

#### 1.3 数据完整性自动检查

生成报告前自动验证：
```markdown
□ 数据来源数 ≥ 深度要求
□ 数据时间覆盖至目标日期（用户指定或current_date）
□ 包含当年最新数据
□ 至少3种来源类型（官方/媒体/研究机构）

任一检查不通过 → 自动补充搜索，不生成不完整报告
```

#### 1.4 报告生成

- 整合所有数据
- **必须包含数据时效声明**
- 添加虾哥 AI Research 水印
- 记录所有数据来源URL

**数据时效声明格式：**
```markdown
**数据时效声明**
- 报告生成日期：{current_date}
- 数据时间范围：{start_date} - {end_date}
- 最新数据日期：{latest_data_date}
- 搜索来源数：{count} 个
- 覆盖完整性：完整/部分（如有缺失需说明）
```

### Phase 2: 文件上传（全自动，必须产生中间产物）

**执行前必须复述：**
```
我将按以下标准 API 流程执行文件上传：
1. 获取 tenant_access_token
2. 上传文件获取 file_token  
3. 创建导入任务获取 ticket
4. 轮询查询 job_status 直到成功

确认：使用 exec + curl，绝不使用 feishu_doc/feishu_drive 工具
```

**Step 1: 获取 Tenant Access Token**

必须使用 curl 调用：
```bash
curl -X POST https://open.feishu.cn/open-apis/auth/v3/tenant_access_token/internal \
  -H "Content-Type: application/json" \
  -d '{
    "app_id": "cli_xxx",
    "app_secret": "xxx"
  }'
```

**✅ 检查点**：成功获取 token 后必须报告：
- `tenant_access_token: t-xxxxx`

**Step 2: 上传文件到云空间**

必须使用 curl 调用（multipart/form-data）：
```bash
curl -X POST "https://open.feishu.cn/open-apis/drive/v1/medias/upload_all" \
  -H "Authorization: Bearer <tenant_access_token>" \
  -F "file_name=xxx.md" \
  -F "parent_type=explorer" \
  -F "parent_node=<FOLDER_TOKEN>" \
  -F "size=<FILE_SIZE>" \
  -F "file=@/path/to/file.md"
```

**✅ 检查点**：上传成功后必须报告：
- `file_token: xxx`

**❌ 合规验证**：如果没有明确报告 file_token，说明使用了 feishu_doc 工具，必须重试。

**Step 3: 创建导入任务**

必须使用 curl 调用：
```bash
curl -X POST "https://open.feishu.cn/open-apis/drive/v1/import_tasks" \
  -H "Authorization: Bearer <tenant_access_token>" \
  -H "Content-Type: application/json" \
  -d '{
    "file_token": "<FILE_TOKEN>",
    "type": "docx",
    "file_extension": "md",
    "file_name": "xxx",
    "point": {
      "mount_type": 1,
      "mount_key": "<FOLDER_TOKEN>"
    }
  }'
```

**✅ 检查点**：创建成功后必须报告：
- `ticket: xxx`

**Step 4: 轮询导入状态**

必须使用 curl 循环查询：
```bash
for i in {1..15}; do
  curl -X GET "https://open.feishu.cn/open-apis/drive/v1/import_tasks/<TICKET>" \
    -H "Authorization: Bearer <tenant_access_token>"
  # 检查 job_status
  sleep 2
done
```

**✅ 检查点**：导入完成后必须报告：
- `job_status: 0`（成功）或 `job_status: 2`（失败）
- `doc_url: https://xxx.feishu.cn/docx/xxx`
- `doc_token: xxx`

**❌ 合规验证**：必须显示完整的轮询过程和最终结果，不能只给一个最终链接。

### Phase 3: 结果汇总（全自动）

完成所有步骤后，汇总输出：
```
✅ 研究完成，{N}个来源已分析
✅ 数据时效：{start_date} 至 {end_date}（最新：{latest_date}）
✅ 文件已上传到云空间
   - File Token: xxx
✅ 导入任务创建成功
   - Ticket: xxx  
✅ 文档导入完成
   - Job Status: 0
   - Doc URL: https://xxx.feishu.cn/docx/xxx
   - Doc Token: xxx
```

## 输入参数

| 参数 | 类型 | 必填 | 说明 |
|------|------|------|------|
| `topic` | string | ✅ | 研究主题，如"特斯拉2025投资分析" |
| `parent_node` | string | ✅ | 飞书云空间文件夹 token |
| `file_name` | string | ❌ | 自定义文档名称（默认使用主题） |
| `date_range` | string | ❌ | 指定日期范围（默认覆盖至current_date） |
| `search_rate` | string | ❌ | 搜索速率（默认1次/秒） |

## 输出结果

```json
{
  "success": true,
  "doc_url": "https://xxx.feishu.cn/docx/xxx",
  "doc_token": "xxx",
  "file_token": "xxx",
  "ticket": "xxx",
  "import_status": "success",
  "job_status": 0,
  "data_range": "2024-01-01 至 2026-02-08",
  "source_count": 25
}
```

## 研究深度选项

| 深度 | 来源数 | 时间覆盖 | 适用场景 |
|------|--------|----------|----------|
| **basic** | ≥5个 | 基础历史数据 | 快速了解 |
| **standard** | ≥10个 | 近2年+当年 | 一般调研 |
| **deep** | ≥20个 | 完整历史+当年最新 | 投资/战略研究 |

**时间覆盖硬性要求：**
- 必须包含当年数据（如今天是2026年，必须有2026年数据）
- 默认覆盖至 current_date（用户可指定历史日期）
- Deep级别至少覆盖最近12个月动态

## 报告结构

自动生成的 Markdown 报告包含以下章节：

```markdown
# {topic} 深度研究报告

**报告生成时间：** {timestamp}  
**研究深度：** {depth}  
**报告机构：** 虾哥 AI Research

**数据时效声明**
- 报告生成日期：{current_date}
- 数据时间范围：{start_date} - {end_date}
- 最新数据日期：{latest_data_date}
- 搜索来源数：{count} 个

---

## 一、执行摘要

### 1.1 核心发现
### 1.2 关键数据

---

## 二、研究背景与定义

### 2.1 研究范围
### 2.2 关键概念

---

## 三、主要研究发现

### 3.1 {子问题1}
### 3.2 {子问题2}
### 3.3 {子问题3}

---

## 四、数据来源与引用

- [来源1] url
- [来源2] url

---

## 五、结论与建议

### 5.1 主要结论
### 5.2 风险提示
### 5.3 后续建议
```

## 配置要求

### Feishu 配置

需要从 OpenClaw 配置中读取以下信息：

```json
{
  "channels": {
    "feishu": {
      "appId": "cli_xxx",
      "appSecret": "xxx"
    }
  }
}
```

使用 `gateway config.get` 获取配置。

如果配置读取失败，提示用户：
> "请提供 Feishu App ID 和 App Secret，或在配置中设置"

### 必要权限

- `drive:file:upload` - 文件上传
- `docs:document:import` - 文档导入
- `drive:drive` - 云空间访问

## 错误处理

### 硬性中断规则（不得降级执行）

遇到以下情况必须**立即停止**，向用户报告，不得生成不完整报告：

1. **搜索API完全不可用**（配置错误或key失效）
2. **无法获取当前日期**（无法确定数据时效性）
3. **飞书API认证失败**（token获取失败）
4. **搜索来源数 < 深度最低要求**（Basic<5, Standard<10, Deep<20）
5. **数据时间覆盖不完整**（缺少当年数据或未达到目标日期）
6. **用户明确说"不要降级"时的任何异常**

### 搜索限流处理

```markdown
遇到限流时：
1. 按当前速率等待（默认1秒）
2. 自动重试（最多3次）
3. 成功 → 继续
4. 失败 → 停止并报告（不降级）
```

### 上传阶段错误

- **API 调用失败**
  - 显示 curl 命令和返回的错误信息
  - 分析错误原因（token失效、权限不足、参数错误等）
  - **禁止**切换到 feishu_doc 工具作为备选
  - 根据错误类型重试或终止

- **配置读取失败**
  - 提示用户输入 App ID 和 App Secret

- **权限不足**
  - 提示用户检查 App 权限设置

- **文件夹 token 无效**
  - 提示用户提供有效的 folder token

### 导入阶段错误

- **导入任务创建失败**
  - 显示错误详情和 API 返回
  - 提供手动导入指南

- **导入状态为 fail (job_status=2)**
  - 显示错误原因
  - 返回 file_token 供手动处理

- **轮询超时**
  - 超过15次轮询仍未完成
  - 报告当前状态并建议手动查询

## 可视化支持

报告支持以下可视化元素：

- 数据表格（Markdown 格式）
- 结构化列表
- 层级标题
- 引用高亮

注意：飞书 API 导入时会自动处理 Markdown 表格，但复杂图表需要在飞书中手动优化。

## 示例

```
/feishu-research "小米集团投资分析" --folder-token L5AOf4DYnlXma7duXAqceWm8nAb

【启动确认】
研究主题：小米集团投资分析
研究深度：deep
数据时效：默认覆盖至 2026年2月8日
搜索速率：默认 1次/秒

请确认或调整：
- 如需指定历史日期范围，请告诉我
- 如需调整搜索速率，请告诉我
- 如无特殊要求，回复"确认"开始执行

用户回复：确认

【执行过程】
Step 1: 前置检查
✅ 当前日期：2026-02-08
✅ 目标时间范围：2024-2026年（覆盖至最近日期）
✅ 搜索API可用

Step 2: 深度研究（全自动）
第一轮：历史基础数据（2024年报）... 10个来源
第二轮：近期表现（2025各季度）... 8个来源
第三轮：最新动态（2026年1-2月）... 12个来源
✅ 共30个来源，覆盖至2026年2月

Step 3: 报告生成
✅ 包含数据时效声明

Step 4: 文件上传
Step 4.1: 获取 Token
✅ tenant_access_token: t-g1042792VRYNWEDIA5OIMF6HM4ERFV26GBJD2WEZ

Step 4.2: 上传文件
✅ file_token: MLjXbh7ZQoyM1gxHTitcqHZ4nNh

Step 4.3: 创建导入任务
✅ ticket: 7603922307581021383

Step 4.4: 轮询导入状态
第1次查询: job_status=0 (成功)
✅ 导入完成

【执行结果】
✅ 研究完成，30个来源已分析
✅ 数据时效：2024-01-01 至 2026-02-08（最新：2026-02-01）
✅ 文件已上传到云空间
   - File Token: MLjXbh7ZQoyM1gxHTitcqHZ4nNh
✅ 导入任务创建成功
   - Ticket: 7603922307581021383
✅ 文档导入完成
   - Job Status: 0
   - Doc URL: https://caz6yhvgk5z.feishu.cn/docx/RdKTdVO5bokpSNxgrjtcZcTenUb
   - Doc Token: RdKTdVO5bokpSNxgrjtcZcTenUb
```

## 技术实现要点

### API 端点

| 步骤 | 端点 | 方法 |
|------|------|------|
| 获取 Token | `/open-apis/auth/v3/tenant_access_token/internal` | POST |
| 上传文件 | `/open-apis/drive/v1/medias/upload_all` | POST |
| 创建导入任务 | `/open-apis/drive/v1/import_tasks` | POST |
| 查询导入状态 | `/open-apis/drive/v1/import_tasks/{ticket}` | GET |

### 关键参数说明

- **mount_type**: 必须是数字 `1`
- **mount_key**: 云空间文件夹 token
- **ticket**: 导入任务查询使用 ticket 而非 task_id
- **job_status**: `0` 表示成功, `2` 表示失败

### 文件大小限制

- Markdown 文件建议不超过 100KB
- 超大报告需要分章节导入

### 等待策略

- 搜索间隔：按确认的速率（默认1秒）
- 导入状态轮询间隔: 2秒
- 最大轮询次数: 15次
- 总超时时间: 30秒

## 合规检查清单

执行完成后，自我检查：

- [ ] 是否使用了 `feishu_doc` 或 `feishu_drive` 工具？（必须：否）
- [ ] 是否使用 `exec + curl` 调用 API？（必须：是）
- [ ] 是否明确报告了 `tenant_access_token`？（必须：是）
- [ ] 是否明确报告了 `file_token`？（必须：是）
- [ ] 是否明确报告了 `ticket`？（必须：是）
- [ ] 是否显示了完整的轮询过程和 `job_status`？（必须：是）
- [ ] 是否提供了完整的 doc_url 和 doc_token？（必须：是）
- [ ] 报告是否包含"数据时效声明"？（必须：是）
- [ ] 数据来源数是否达到深度要求？（必须：是）
- [ ] 数据时间是否覆盖至目标日期？（必须：是）

**如果任何一项未通过，必须重新执行。**

## 注意事项

1. ⚠️ **禁止使用**：`feishu_doc create`、`feishu_drive` 等封装工具
2. ⚠️ **必须使用**：`exec` + `curl` 直接调用飞书 REST API
3. ⚠️ **必须产生**：完整的中间产物（token, file_token, ticket, job_status）
4. ⚠️ **必须报告**：每个步骤的明确结果
5. ⚠️ **必须验证**：执行完成后进行合规检查
6. ⚠️ **必须包含**：数据时效声明
7. ✅ 保留 `虾哥 AI Research` 水印
8. ✅ 记录所有数据来源URL
9. ✅ 默认数据覆盖至 current_date（用户可覆盖）
10. ✅ 默认搜索速率 1次/秒（用户可覆盖）

## 违反技术约束的处理

如果执行过程中发现使用了封装工具或数据不完整：

1. **立即停止**当前执行
2. **报告错误**："检测到违反技术约束或数据不完整。"
3. **解释原因**：具体说明违规项（使用封装工具/缺少当年数据/来源不足等）
4. **重新执行**：按规范流程重新执行
5. **不要**：假装成功、跳过关键步骤、或生成不完整报告

## 版本历史

- **v2.0** (2026-02-08): 
  - 新增启动确认（唯一交互点）
  - 新增时间范围自动检查（默认覆盖至current_date）
  - 新增搜索速率确认（默认1次/秒）
  - 新增数据时效声明（强制包含）
  - 新增硬性中断规则（禁止降级执行）
  - 优化搜索策略（按时间分层）
  
- **v1.0**: 初始版本
