const fs = require('fs');
const path = require('path');
const { execSync } = require('child_process');

console.log('🧪 Testing feishu-card skill...');

const sendPath = path.join(__dirname, 'send.js');

// 1. Check existence
if (!fs.existsSync(sendPath)) {
  console.error('❌ send.js not found!');
  process.exit(1);
}
console.log('✅ send.js exists');

// 2. Check syntax (dry-run import)
try {
  require.resolve('./send.js');
  console.log('✅ send.js is valid Node.js module');
} catch (e) {
  console.error('❌ send.js syntax check failed:', e);
  process.exit(1);
}

// 3. Check help output
try {
  const output = execSync(`node ${sendPath} --help`, { encoding: 'utf8' });
  if (output.includes('Usage: send')) {
    console.log('✅ CLI help command works');
  } else {
    throw new Error('Help output missing usage');
  }
} catch (e) {
  console.error('❌ CLI execution failed:', e);
  process.exit(1);
}

console.log('🎉 feishu-card basic sanity tests passed!');
