const Lark = require('@larksuiteoapi/node-sdk');
require('dotenv').config({ path: require('path').resolve(__dirname, '../../.env') });

const APP_ID = process.env.FEISHU_APP_ID;
const APP_SECRET = process.env.FEISHU_APP_SECRET;
const MASTER_ID = process.env.OPENCLAW_MASTER_ID;
const client = new Lark.Client({ appId: APP_ID, appSecret: APP_SECRET });

(async () => {
    // Attempt 2: Search for calendar
    console.log("Searching for Master's calendar...");
    try {
        const res = await client.calendar.calendar.search({
            data: {
                query: "张昊阳" // Search by name?
            }
        });
        if (res.code === 0 && res.data.items) {
            console.log("Found Calendars:", res.data.items.map(c => `${c.summary} (${c.calendar_id})`));
        } else {
            console.log("Search failed or empty:", res);
        }
    } catch(e) { console.error("Search Error:", e.message); }
})();
