const Lark = require('@larksuiteoapi/node-sdk');
require('dotenv').config({ path: require('path').resolve(__dirname, '../../.env') });

const APP_ID = process.env.FEISHU_APP_ID;
const APP_SECRET = process.env.FEISHU_APP_SECRET;
const client = new Lark.Client({ appId: APP_ID, appSecret: APP_SECRET });

(async () => {
    console.log("Listing Calendars...");
    const res = await client.calendar.calendar.list();
    if (res.code === 0) {
        res.data.calendar_list.forEach(c => {
            console.log(`- [${c.summary}] ID: ${c.calendar_id} (Role: ${c.role})`);
        });
    } else {
        console.error("Error:", res);
    }
})();
