---
name: feishu-ai-dailyreport
description: 生成飞书AI助手团队工作日报。每天自动收集团队成员的工作内容，整理成日报，保存文件并发送到飞书。触发场景：用户说"生成日报"、"整理日报"、"工作日报"等；定时任务（每天18点）调用。重要：必须严格按照模板格式输出，不得更改格式。
---

# AI 助手工作日报生成

这个技能用于生成 AI 助手团队的工作日报，包括团队成员的工作内容整理、格式化输出、文件保存和飞书消息发送。

## 工作流程

### 1. 读取团队成员信息

从 `/root/.openclaw/workspace/feishu-apps-list.md` 读取所有团队成员信息，包括：
- 应用名称
- 成员昵称
- 角色
- 工作区路径

### 2. 收集工作内容

对每个团队成员，通过以下方式收集工作内容：

**主要方法：使用 session history**
- 使用 `sessions_list` 列出所有活跃的 session
- 对每个团队成员的 session，使用 `sessions_history` 读取当天的聊天记录
- 从聊天记录中提取工作任务和完成情况

**备用方法：读取 memory 文件**
- 如果存在 `memory/YYYY-MM-DD.md` 文件，从中读取当天的工作记录

### 3. 识别团队成员

从飞书应用列表中动态识别团队成员，支持成员动态增减。每个成员包括：
- 名字（如：小明、小王、芮芮等）
- 角色（如：系统架构师、运维工程师、总助理等）
- 对应的 session 或 workspace

### 4. 生成日报内容

按照以下模板生成日报：

```
📅 AI助手工作日报（YYYY-MM-DD）
生成时间：YYYY-MM-DD HH:MM:SS

📊 团队工作总览
- 🏗️ [名字]（[角色]）：[工作内容简述]
- 🔧 [名字]（[角色]）：[工作内容简述]
...

📝 详细工作内容

🏗️ [名字]（[角色]）
1. [工作项1]
2. [工作项2]
...

🔧 [名字]（[角色]）
1. [工作项1]
2. [工作项2]
...

---
*日报由芮芮自动生成*
```

**Emoji 映射表**（根据角色选择）：
- 🏗️ 系统架构师
- 🔧 运维工程师
- 📋 总助理
- 🌐 浏览器操作助手
- 💰 股票助手
- 📝 内容写手
- 💕 AI女友开发项目 / 临时项目
- 🔍 研发工程师
- 🎨 设计师
- 📊 数据分析师
- 🤖 其他角色

### 5. 保存日报文件

将生成的日报保存到 `/root/.openclaw/workspace/daily-report-YYYY-MM-DD.md`

### 6. 发送到飞书

使用 `message` 工具将日报发送到芮芮的飞书聊天（当前 session）：
- Channel: `feishu`
- 不需要指定 target（默认发送到当前对话）

## 关键点

1. **自动发现团队成员**：从 `feishu-apps-list.md` 动态读取，支持成员增减
2. **时间过滤**：只收集当天（从 00:00:00 到 23:59:59）的工作内容
3. **空成员处理**：如果某成员当天没有工作，显示"今日无工作"或类似提示
4. **格式一致性**：严格按照模板格式输出，包括 emoji、标题层级等
5. **时间戳**：生成时间使用当前时间，格式为 `YYYY-MM-DD HH:MM:SS`

## 工具使用

### sessions_list
列出所有 session，用于识别团队成员对应的 session。

```json
{
  "limit": 50,
  "activeMinutes": 1440  // 过去24小时活跃的session
}
```

### sessions_history
读取指定 session 的聊天历史。

```json
{
  "sessionKey": "session_key",
  "limit": 100,
  "includeTools": false
}
```

### read
读取飞书应用列表文件。

```json
{
  "path": "/root/.openclaw/workspace/feishu-apps-list.md"
}
```

### write
保存日报文件。

```json
{
  "path": "/root/.openclaw/workspace/daily-report-YYYY-MM-DD.md",
  "content": "日报内容"
}
```

### message
发送日报到飞书。

```json
{
  "action": "send",
  "channel": "feishu",
  "message": "日报内容"
}
```

## 输出格式要求

### 团队工作总览部分
- 每个成员一行，使用 `- ` 开头
- 格式：`[emoji] [名字]（[角色]）：[工作内容简述]`
- 如果无工作，可以写："今日无工作" 或 "空闲"

### 详细工作内容部分
- 每个成员一个独立章节
- 标题格式：`[emoji] [名字]（[角色]）`
- 工作项使用数字列表：`1. [工作项]`
- 如果无工作，可以写："今日无工作内容"

### 结尾部分
- 添加分隔线 `---`
- 添加备注 `*日报由芮芮自动生成*`

## 错误处理

1. **飞书应用列表不存在**：提示用户确保 `feishu-apps-list.md` 文件存在
2. **session 读取失败**：跳过该 session，继续处理其他成员
3. **文件保存失败**：提示用户检查文件权限
4. **飞书发送失败**：日报已保存到文件，可以手动发送

## 定时任务说明

此技能可以通过 OpenClaw 的 cron 功能设置为每天 18:00 自动执行。
具体实现：使用 `openclaw cron` 命令创建定时任务，每天 18:00 调用此技能生成并发送日报。

## 严格要求

生成日报时，**必须**严格按照以下格式，不得有任何改动：

1. 第一行：`📅 AI助手工作日报（YYYY-MM-DD）`
2. 第二行：`生成时间：YYYY-MM-DD HH:MM:SS`
3. 第三行：空行
4. 第四行：`📊 团队工作总览`
5. 每个成员：`- [emoji] [名字]（[角色]）：[工作内容简述]`
6. 空行
7. `📝 详细工作内容`
8. 每个成员：
   - 标题：`[emoji] [名字]（[角色]）`
   - 每个工作项：`1. [工作内容]`
   - 无工作：`今日无工作内容`
9. 空行
10. `---`
11. `*日报由芮芮自动生成*`

**禁止的格式：**
- ❌ 不要使用 `## 今日完成工作`
- ❌ 不要使用 `### 1. xxx`
- ❌ 不要使用其他任何标题格式
- ❌ 不要修改 emoji 的使用方式

**只允许的格式：**
- ✅ 必须完全按照上面的模板格式
- ✅ 只能替换占位符（YYYY-MM-DD、名字、角色、工作内容）
