# 🍽️ Feed Diet

> **Audit your information diet.** See what you actually consume across Hacker News and RSS feeds — then decide if that's what you want.

Feed Diet fetches your reading history, classifies every item into 7 categories using LLM (or smart keyword matching), and generates a gorgeous report you'll want to screenshot.

## OpenClaw Discord v2 Ready

Compatible with OpenClaw Discord channel behavior documented for v2026.2.14+:
- Compact first summary (top category + recommendations), full report on demand
- Component-style quick actions when available (`Show Full Diet Report`, `Generate Weekly Digest`, `Show Recommendations`)
- Numbered-list fallback when components are unavailable

## Install

```bash
clawhub install feed-diet
```

## Quick Start

```bash
# Audit an HN account
./scripts/feed-diet.sh audit --hn tosh --limit 50

# Audit your RSS feeds
./scripts/feed-diet.sh audit --opml ~/feeds.opml

# Get a goal-focused weekly digest
./scripts/feed-diet.sh digest --hn tosh --goal "systems, compilers, rust" --days 7
```

## What You Get

### Full Diet Report

```
# 🍽️  Feed Diet Report

**Source:** HN user: tosh (last 50 stories)
**Items analyzed:** 50
**Generated by:** Feed Diet v0.1.1

## 📊 Category Breakdown

| Rank | Category | Count | Pct | Distribution |
|------|----------|------:|----:|--------------|
| 1 | 🔬 deep-technical | 22 | 44.0% | `█████████░░░░░░░░░░░` |
| 2 | 📰 news | 11 | 22.0% | `████░░░░░░░░░░░░░░░░` |
| 3 | 💬 opinion | 6 | 12.0% | `██░░░░░░░░░░░░░░░░░░` |
| 4 | 📚 tutorial | 4 | 8.0% | `██░░░░░░░░░░░░░░░░░░` |
| 5 | 🪞 meta | 4 | 8.0% | `██░░░░░░░░░░░░░░░░░░` |
| 6 | 🎮 entertainment | 2 | 4.0% | `█░░░░░░░░░░░░░░░░░░░` |
| 7 | 🔥 drama | 1 | 2.0% | `░░░░░░░░░░░░░░░░░░░░` |

## 🏆 Top Categories

🥇 **🔬 deep-technical** — 44.0% (22 items)
   • What the hell is Forth? (2019)
   • How many registers does an x86-64 CPU have? (2020)
   • Moving Forth (1993)

🥈 **📰 news** — 22.0% (11 items)
   • ByteDance Seed 2.0
   • Starlink is connecting more than 10M active customers
   • MiniMax M2.5 weights

🥉 **💬 opinion** — 12.0% (6 items)
   • OpenAI Should Build Slack
   • Taste for Makers
   • The Final Bottleneck

## 🤔 Surprising Finds

🔬 **44.0% deep-technical** — Impressive depth! You're investing in real understanding.

😤 **0% entertainment** — All work and no play! Consider some lighter content.

💬 **Opinion-to-Tutorial ratio: 1.5:1** — You're reading a lot more opinions than practical guides.

🌈 **Diversity score: 100%** — Excellent variety! You're reading across many categories.

## 💡 Recommendations

1. 📚 **More tutorials:** Active learning beats passive reading. Seek out how-to content.
2. 🎮 **Have some fun:** A healthy diet includes some entertainment and humor.
3. ⚖️ **Balance opinions with practice:** For every opinion piece, read a tutorial or paper.

## 📈 Quick Stats

- **Total items:** 50
- **Categories used:** 7/7
- **Diversity score:** 100%
- **Top 3 concentration:** 78.0%
- **#1 category:** 🔬 deep-technical (44.0%)

---
*Generated by Feed Diet v0.1.1 🍽️*
```

### Weekly Digest

```
# 📬 Weekly Feed Diet Digest

**Goal:** systems programming, compilers, Forth
**Source:** HN user: tosh (last 7 days)
**Matching items:** 12 (showing top 12)

## 🎯 Your Curated Reading List

 1. 🔬 [What the hell is Forth? (2019)](https://blog.information-superhighway.net/...)
 2. 🔬 [How many registers does an x86-64 CPU have?](https://blog.yossarian.net/2020/11/30/...)
 3. 🔬 [Moving Forth (1993)](https://www.bradrodriguez.com/papers/moving1.htm)
 4. 📚 [1x Forth: Chuck Moore on Forth (1999)](https://www.youtube.com/watch?v=NK0NwqF8F0k)
 5. 🔬 [colorForth Tokens (2022)](https://www.youtube.com/watch?v=zl5IEpUBxfc)
 6. 🔬 [jonesforth](https://github.com/nornagon/jonesforth)
 7. 📰 [Cognate](https://cognate-lang.github.io/)
 8. 📰 [uiua 0.18.0](https://www.uiua.org/blog/uiua-0.18.0)
 9. 🔬 [colorForth](https://colorforth.github.io/cf.htm)
10. 📚 [Advent of Code in Forth](https://www.youtube.com/watch?v=jAFz8Maxvr4)

**Digest breakdown:** 🔬 deep-technical: 6, 📰 news: 2, 📚 tutorial: 2

---
*Feed Diet Weekly Digest v0.1.1 🍽️*
```

## Categories

| Category | Emoji | Description |
|----------|-------|-------------|
| `deep-technical` | 🔬 | Papers, systems design, low-level programming |
| `news` | 📰 | Announcements, releases, current events |
| `opinion` | 💬 | Editorials, essays, hot takes |
| `drama` | 🔥 | Controversy, outrage, conflict |
| `entertainment` | 🎮 | Fun, humor, lifestyle, art |
| `tutorial` | 📚 | How-tos, guides, educational content |
| `meta` | 🪞 | Industry navel-gazing, AI hype, meta-discussion |

## Configuration

### LLM Classification (recommended)

Set one of these environment variables for high-quality classification:

```bash
export ANTHROPIC_API_KEY="sk-ant-..."   # Uses Claude
export OPENAI_API_KEY="sk-..."          # Uses GPT-4o-mini
```

Without an API key, Feed Diet falls back to keyword-based classification — decent but not as nuanced.

### Options

| Flag | Default | Description |
|------|---------|-------------|
| `--hn USER` | — | Hacker News username |
| `--opml FILE` | — | Path to OPML file |
| `--limit N` | 100 | Max items to analyze |
| `--goal "X"` | — | Goal topics for digest (comma-separated) |
| `--days N` | 7 | Lookback window for digest |
| `--output FILE` | stdout | Write report to file |

## How It Works

1. **Fetch** — Pulls your submitted stories from HN API or items from RSS feeds
2. **Classify** — Batches of 25 items sent to LLM for categorization (or keyword fallback)
3. **Report** — Generates Markdown with ASCII charts, insights, and recommendations
4. **Digest** — (Optional) Filters items by your stated goals for a curated reading list

## Requirements

- `bash` 4+
- `curl`
- `python3` (for JSON parsing — no pip packages needed)
- Optional: `ANTHROPIC_API_KEY` or `OPENAI_API_KEY` for LLM classification

## Roadmap (v0.1.2+)

- [ ] Reddit user history analysis
- [ ] YouTube subscription audit
- [ ] Feed-by-feed quality scores
- [ ] Diet trend tracking over time
- [ ] Export to HTML with actual pie charts
- [ ] "Focus mode" — block categories during work hours

## License

MIT

---

Built by **[Anvil AI](https://anvil-ai.io)**.

