# Theme Research Guide

How to create an authentic cultural experience alongside a meal.

## Philosophy

A Feast meal isn't just food. It's a window into a place — a chance to travel without leaving your kitchen. The theme dossier is your research into that place, so the experience feels genuine, not tokenistic.

**The goal:** When someone sits down to eat, they should feel transported. The music, the context, the story — it all combines to make a Tuesday evening feel like a mini-adventure.

## Research Process

### 1. Identify the Specific Origin

Don't stop at "Thai food." Ask:
- Which region of Thailand?
- Which city or town is famous for this dish?
- Is there a specific origin story?

**Bad:** "Japanese ramen"  
**Better:** "Hakata-style tonkotsu ramen from Fukuoka, Kyushu"

**Bad:** "Indian curry"  
**Better:** "Chettinad chicken from Tamil Nadu's Chettinad region"

The more specific you can get, the richer the experience. A dish from Oaxaca has different music, history, and context than a dish from Mexico City.

### 2. Research the Region (Not Just the Dish)

Spend 10-15 minutes understanding the *place*:
- What is this region known for beyond food?
- What's its character? Industrial? Agricultural? Artistic? Coastal?
- What's the climate, the landscape?
- What's its history in 2-3 sentences?
- What do people there do for work, for fun?

**Sources:**
- Wikipedia (for basics — then go deeper)
- Travel blogs and vlogs (for vibe and atmosphere)
- Local news sites (for current context)
- YouTube travel videos (for visual feel)
- Reddit travel communities (for honest perspectives)

**Write evocatively, not encyclopedically.** You're painting a picture, not writing a textbook entry.

### 3. Find Current Context

Search for recent news or cultural moments:
- "[Region name] news"
- "[Country] [Region] 2026"
- What's happening there right now?
- Any festivals, elections, cultural events, sports?
- Seasonal context (harvest time? Monsoon? Ski season?)

This makes the experience feel *alive*, not like a museum exhibit. The world is happening there right now — connect to that.

### 4. Curate Music (The Hard Part)

**DO NOT just search "[Cuisine] playlist" on Spotify.** Those are usually generic compilations assembled for Western audiences, full of stereotypes and safe choices.

Instead:

#### Contemporary (What People There Listen to NOW)

- Search: "[Country] charts 2026", "[Country] top hits"
- Look at local streaming charts (Spotify has country-specific charts under Browse → Charts)
- Search: "popular music in [Region]" or "[Region] musicians"
- Look for local genres, not just international pop
- Check what's trending on local radio (Wikipedia often lists popular stations)
- Search: "[Country] music scene" or "[City] music"
- Use translation skills and local searches if needed

**Ask:** Would someone from this region actually listen to this? Or is this "world music for tourists"?

#### Classic/Traditional

- Search: "[Country] traditional music", "[Region] folk music"
- Look for legendary artists from that region specifically
- Find music from the era the dish became famous
- For regional dishes, search "[Region] music" not just country
- Search: "greatest [Country] musicians" or "[Region] famous singers"
- Look for the artists who influenced modern music there

#### Understand Local Genres

Every region has its own sounds:
- **Korea:** K-pop, trot, Korean indie, Korean R&B
- **Brazil:** Samba, bossa nova, MPB, sertanejo, funk carioca
- **Nigeria:** Afrobeats, jùjú, highlife, fuji
- **Vietnam:** V-pop, nhạc trữ tình, nhạc vàng
- **Mexico:** Regional Mexican, norteño, cumbia, rock en español

Research what genres are *from* your target region, then find artists within those.

#### Build a Journey (1-2 Hours)

Your playlist should have an arc:
1. **Opening (15-20 mins):** Gentle, mood-setting — background while cooking
2. **Build (20-30 mins):** Energy rising as the meal comes together
3. **Peak (20-30 mins):** The heart of the experience — eating, enjoying
4. **Wind down (15-20 mins):** Relaxed, satisfied, contemplative

**Mix contemporary and classic** — don't make it all traditional or all modern.

**Consider instrumentals for eating** — lyrics (especially in a language you understand) can distract from conversation and food.

### 5. Verify Authenticity

Ask yourself:
- Would someone from this region recognise this music?
- Is this "world music for Westerners" or actual local music?
- Am I defaulting to stereotypes? (Not all Italian food needs opera. Not all Indian food needs sitar.)
- Did I actually look at local sources, or just English-language sites?

**Confidence levels:**
- **High:** Found local sources, verified artists are from the region, multiple corroborating sources
- **Medium:** Found good sources but couldn't verify everything, relying partly on English-language compilations
- **Low:** Mostly guessing based on genre, needs more research

**Be honest.** It's okay to say "I'm not confident about this music selection" — better than pretending.

### 6. Set the Scene

Beyond music, consider:
- **Serving:** How would this be served in the region? Shared plates? Individual portions? Eaten with hands, chopsticks, bread?
- **Drinks:** What would people drink with it? Beer, wine, tea, soft drinks, something specific?
- **Table setting:** Any simple touches that fit the vibe? (Don't go overboard — a candle and the right music go further than buying props)
- **Ambient sounds:** For some cuisines, background ambience can help — rain sounds for Southeast Asia, market chatter for street food, etc. (Optional, not essential)

## Time Budget

For each themed meal:
- **Quick version (15-20 mins):** Basic regional context + playlist search with some curation
- **Standard version (30-45 mins):** Full dossier with researched music
- **Deep dive (60+ mins):** For special occasions or completely unfamiliar cuisines

It's okay to do quick versions for regular weeknight meals and save full dossiers for special themes, exploratory cuisines, or when you're trying to impress.

## Building a Library

After researching a region once, save what you learned:
- Add notes to `references/cuisines/[cuisine].md`
- Save useful Spotify playlists
- Note good artists for future reference

This reduces future research effort. The first Thai meal takes 45 minutes to research; the fifth takes 10.

## Red Flags (What to Avoid)

❌ **Generic "world music" playlists** — These are for airports and hotel lobbies, not cultural immersion

❌ **Stopping at country level** — "Chinese food" could mean Sichuan, Cantonese, Hunan, Xinjiang... they're completely different

❌ **Stereotypical music choices** — Not all Italian food needs Pavarotti. Not all Mexican food needs mariachi.

❌ **Ignoring contemporary culture** — Places are alive, not frozen in time. Include modern music.

❌ **Making it up** — If you can't find good information, say so. Don't invent "facts."

❌ **Cultural tourism vs appreciation** — Research with respect. You're a guest, not a coloniser. Don't mock or trivialise.

❌ **Overwhelming the meal** — The food is the star. The theme supports it, doesn't overshadow it.

## Example: Good vs Bad

**Dish:** Pad Thai

**Bad approach:**
- Music: Search "Thai restaurant music" → get generic pan-Asian ambient
- Context: "Thailand is in Southeast Asia, known for beaches"
- Result: Background noise that could accompany any Asian food

**Good approach:**
- Region: Pad Thai is street food, popularised in Bangkok mid-20th century
- Context: Thailand's current music scene, street food culture, night market vibe
- Contemporary: Current Thai pop hits, Bodyslam, Palmy
- Classic: Luk thung classics, Carabao, Suthep Wongkamhaeng
- Playlist: Starts relaxed, builds to energetic street-night-market vibe, cools down
- Result: Feels like Bangkok on a warm evening

## Where It Goes

All theme research is embedded directly into the weekly plan file (`workspace/meals/weeks/YYYY-MM-DD.md`). Each day in the week plan has sections for:

- `place` — Regional context and description
- `dish` — Full recipe with origin story
- `music` — Curated playlist with contemporary and classic tracks
- `atmosphere` — Serving and ambience suggestions
- `research` — Sources and confidence level

See [templates/week.md](../templates/week.md) for the full structure.

Research as you go — fill in each section as you discover information. Don't try to complete everything perfectly before you start.
