# UK Seasonal Produce Guide

What's in season throughout the year in the United Kingdom.

## How to Use

When planning meals, prefer seasonal produce where practical. This guide shows peak seasons — many items are available year-round but are best (and often cheapest) in season.

## Monthly Calendar

### January
**Vegetables:** Brussels sprouts, cabbage, cauliflower, celeriac, chicory, Jerusalem artichokes, kale, leeks, parsnips, purple sprouting broccoli (late), swede, turnips
**Fruit:** Apples (stored), pears (stored), rhubarb (forced)

### February  
**Vegetables:** Brussels sprouts, cabbage, cauliflower, celeriac, chicory, kale, leeks, parsnips, purple sprouting broccoli, swede
**Fruit:** Rhubarb (forced)

### March
**Vegetables:** Cauliflower, kale, leeks, purple sprouting broccoli, spring greens, spring onions
**Fruit:** Rhubarb

### April
**Vegetables:** Asparagus (starts), purple sprouting broccoli, radishes, rocket, spinach, spring greens, spring onions, watercress
**Fruit:** Rhubarb

### May
**Vegetables:** Asparagus, broad beans, Jersey Royal potatoes, new potatoes, radishes, rocket, spinach, spring onions, watercress
**Fruit:** Rhubarb, strawberries (start)

### June
**Vegetables:** Asparagus (ends), broad beans, courgettes, new potatoes, peas, radishes, runner beans, samphire, spinach
**Fruit:** Cherries, gooseberries, raspberries, strawberries

### July
**Vegetables:** Aubergines, beetroot, broad beans, carrots, courgettes, cucumber, fennel, French beans, lettuce, new potatoes, peas, radishes, runner beans, tomatoes
**Fruit:** Blackcurrants, blueberries, cherries, gooseberries, raspberries, redcurrants, strawberries

### August
**Vegetables:** Aubergines, beetroot, carrots, courgettes, cucumber, fennel, French beans, lettuce, marrow, peppers, potatoes, runner beans, sweetcorn, tomatoes
**Fruit:** Blackberries, blueberries, damsons, greengages, plums, raspberries, strawberries

### September
**Vegetables:** Aubergines, beetroot, broccoli, butternut squash, carrots, courgettes, kale, leeks, lettuce, marrow, onions, parsnips, peppers, potatoes, pumpkins, runner beans, sweetcorn, tomatoes, turnips
**Fruit:** Apples, blackberries, damsons, elderberries, pears, plums, raspberries

### October
**Vegetables:** Beetroot, broccoli, Brussels sprouts, butternut squash, cabbage, carrots, cauliflower, celeriac, kale, leeks, onions, parsnips, potatoes, pumpkins, swede, turnips, winter squash
**Fruit:** Apples, chestnuts, pears, quinces

### November
**Vegetables:** Beetroot, Brussels sprouts, cabbage, carrots, cauliflower, celeriac, Jerusalem artichokes, kale, leeks, onions, parsnips, potatoes, pumpkins, swede, turnips
**Fruit:** Apples (stored), chestnuts, cranberries, pears (stored), quinces

### December
**Vegetables:** Brussels sprouts, cabbage, carrots, cauliflower, celeriac, Jerusalem artichokes, kale, leeks, parsnips, potatoes, red cabbage, swede, turnips
**Fruit:** Apples (stored), chestnuts, cranberries, pears (stored)

## Year-Round Availability

These items are available year-round (often imported when not UK season):
- Onions, garlic, potatoes (maincrop)
- Carrots, cabbage
- Mushrooms
- Bananas, citrus fruits (always imported)

## Seasonal Highlights

### Spring (Mar-May)
⭐ Asparagus (British asparagus season: late April to late June)
⭐ Jersey Royals (May-July)
⭐ Purple sprouting broccoli
⭐ Forced rhubarb → outdoor rhubarb

### Summer (Jun-Aug)
⭐ British strawberries (peak June-July)
⭐ Peas and broad beans
⭐ British tomatoes
⭐ Courgettes (glut in August)
⭐ Soft fruits: raspberries, cherries, currants

### Autumn (Sep-Nov)
⭐ British apples and pears
⭐ Squash and pumpkins
⭐ Wild mushrooms
⭐ Blackberries (free foraging!)
⭐ Game season begins (grouse Aug 12, pheasant Oct 1)

### Winter (Dec-Feb)
⭐ Brussels sprouts (best after first frost)
⭐ Root vegetables: parsnips, swede, celeriac
⭐ Kale and winter cabbage
⭐ Forced rhubarb (Yorkshire triangle, Jan-Mar)

## Sourcing Tips

### Supermarkets
- Look for "British" labels
- Seasonal items often on offer when abundant
- Wonky veg boxes reduce waste and cost

### Farmers Markets
- Best for truly local, seasonal produce
- Find your local: farmersmarkets.net
- Often cheaper for seasonal gluts

### Box Schemes
- Riverford, Abel & Cole, Oddbox
- Forces seasonal eating
- Good for discovering new vegetables

## Notes

- "Stored" means harvested earlier but stored (apples, potatoes)
- Forced rhubarb is grown in dark sheds (Yorkshire specialty)
- Seasons shift slightly year to year with weather
- Climate change is extending some seasons
