# Seasonality Guides

Location-aware seasonal produce information.

## Structure

```
seasonality/
├── README.md (this file)
├── uk.md
├── us.md (with regional variants)
├── eu.md (with country variants)
├── au.md
└── ... (added as needed)
```

## Per-Region Content

Each file includes:

1. **Monthly produce calendar** — What's in season when
2. **Key seasonal highlights** — The stars of each season
3. **Preservation notes** — What can be frozen/preserved
4. **Sourcing notes** — Farmers markets, local options

## Why Seasonality Matters

- **Quality** — In-season produce tastes better
- **Cost** — Usually cheaper when abundant
- **Environment** — Less transport, less storage
- **Variety** — Forces natural rotation through the year

## Not Dogmatic

Feast uses seasonality as a preference, not a rule. Not every ingredient in a meal needs to be in season — that would be overly restrictive. But when choosing between options, prefer seasonal.

## Building This Library

Start with the user's location. Add other regions as users from those areas are onboarded.
