# Price Checking Guide

How to find deals and optimise shopping costs.

## Philosophy

Cooking should be accessible. Part of Feast's intelligence is helping users shop smart — not just generating a list, but helping them get value for money without sacrificing quality.

**The goal:** Identify where the user can save meaningful money, especially on expensive items, without making shopping a chore.

## When to Price Check

### Always Check
- **Proteins** — Often the most expensive items (meat, fish, quality plant proteins)
- **Specialty ingredients** — Anything not in a regular shop
- **Large quantities** — Where savings multiply
- **Items over £5** (or regional equivalent)

### Skip Checking
- **Storecupboard staples** — Oil, salt, basic spices (prices don't vary much)
- **Very cheap items** — A single onion, garlic bulb (not worth the research time)
- **Quality-critical items** — Sometimes fresh herbs, good cheese — where cheapest isn't best

## The Process

### 1. Identify Target Ingredients

From the shopping list, flag:
- **Top 3-5 most expensive items** (usually proteins, cheese, specialty items)
- **Any items over £5** (or local threshold)
- **Bulk items** (rice, pasta in quantity — savings multiply)
- **Items user is price-sensitive about** (learn from their feedback)

### 2. Check Across User's Stores

The user's profile lists their accessible stores. For each flagged item:

**Search patterns:**
- "[Store name] [ingredient]" — direct product search
- "[Store name] offers this week" — check current promotions
- Store websites/apps where possible — most accurate

**Quick store check (under 5 mins):**
- Check 2-3 stores for top 3 items
- Note obvious deals or big price differences
- Good enough for most weeks

**Full store check (10-15 mins):**
- Check all user's stores for flagged items
- Compare unit prices (price per kg, per 100g)
- Note multi-buy offers
- Worth it for expensive weeks or strict budgets

### 3. UK Stores Quick Reference (update for other regions as appropriate)

| Store | Best For | Notes |
|-------|----------|-------|
| **Tesco** | All-rounder | Check Clubcard prices (significant savings) |
| **Sainsbury's** | Quality + range | Nectar prices, good substitutes |
| **Asda** | Budget basics | Often cheapest for staples |
| **Morrisons** | Meat + fish | Good butcher counter, quality proteins |
| **Lidl** | Weekly specials | Great value but limited stock, check Thursday offers |
| **Aldi** | Weekly specials | Similar to Lidl, check Sunday/Thursday offers |
| **Waitrose** | Quality | Premium pricing, but quality reflects it |
| **M&S** | Convenience | Premium, but "Remarksable" range is good value |
| **Co-op** | Convenience | Local but pricier, member offers |
| **Iceland** | Frozen | Good for frozen proteins, bulk |

**Discount store notes:**
- Lidl and Aldi offers change weekly and have limited stock
- Worth checking but don't rely on availability
- Go early for best selection on offer items

### 4. Compare and Recommend

For each checked item, note:
- **Cheapest option:** Store + price
- **Best value option:** May differ if quality matters
- **Deal alert:** Any current offers or multi-buys worth highlighting
- **Caveats:** "May sell out", "Clubcard price only", etc.

### 5. Shopping Strategy

Based on findings, suggest one of:

**Single store strategy:**
> "Do the whole shop at Tesco — best overall value this week."

**Split strategy:**
> "Proteins at Aldi (save £4), everything else at Tesco for convenience."

**Deal-driven strategy:**
> "Lidl has salmon at half price — worth a quick stop before your main shop."

Consider:
- User's time (is a second stop worth £3 savings?)
- User's preference (some people hate multi-store shopping)
- Actual savings (don't split for £1 difference)

## Shopping List Format with Prices

When presenting the shopping list, integrate price guidance:

```markdown
## 🥩 Proteins

- [ ] Chicken thighs, 500g — **~£3.50**  
  💰 *Best: Aldi (£2.99) or Tesco Clubcard (£3.00)*
  
- [ ] Salmon fillets, 2x — **~£5.00**  
  ⭐ *Deal: Sainsbury's 2-for-£8 this week*

## 🥬 Vegetables

- [ ] Broccoli, 1 head — ~£1.00
- [ ] Peppers, 3 pack — ~£1.50  
  💰 *Cheaper loose at Aldi*
```

Use icons sparingly:
- 💰 = Notable saving available
- ⭐ = Deal/offer worth grabbing
- ⚠️ = Stock warning (Lidl/Aldi offers)

## Price Data Limitations

**Be honest about limitations:**
- Prices change frequently (especially proteins)
- Online prices may differ from in-store
- Offers expire mid-week
- Stock varies by location
- Quality varies (cheap chicken might be poor quality)

**Always include:**
> "Prices checked [date]. Verify in-store — prices and availability may vary."

## Multi-Store Strategy Guidance

### Recommend multi-store when:
- Savings are significant (>£5 total difference)
- Stores are convenient to each other
- User has indicated they're happy to shop around
- There's a standout deal worth grabbing

### Recommend single-store when:
- Savings are marginal (<£3 difference)
- User has indicated time-poor or convenience-focused
- Quality concerns at cheapest store
- Deals require bulk buying user doesn't need

## Learning User Preferences

Track over time:
- Which stores they actually use (vs what they listed)
- Feedback on price recommendations
- Whether they follow multi-store suggestions
- Items where they prefer quality over price

Update recommendations based on behaviour, not just initial profile.

## Time Budget

- **Quick check (5-10 mins):** Top 3 items, 2-3 stores — sufficient for most weeks
- **Standard check (10-15 mins):** All flagged items, all stores — for expensive weeks
- **Budget week (15-20 mins):** Deep comparison, unit prices, offers — for strict budget periods

Default to quick check. Only go deeper if:
- User is on a strict budget
- It's an expensive week (specialty ingredients, entertaining)
- User has asked for extra attention to costs

## UK Supermarket Price Tracking Resources

Some useful tools (update for regional variance as needed):
- **Trolley.co.uk** — Compares prices across major supermarkets
- **MySupermarket** (deprecated but alternatives exist)
- **Store apps** — Tesco, Sainsbury's apps show current prices and offers
- **HotUKDeals** — Community-posted supermarket deals

Don't over-rely on these — a quick manual check of 2-3 stores is often faster and more reliable.

## Example: Price Check in Action

**Flagged items for the week:**
1. Lamb mince, 500g (expensive protein)
2. King prawns, 200g (specialty, pricey)
3. Parmesan, 100g (quality cheese)

**Quick check (8 mins):**

| Item | Tesco | Sainsbury's | Aldi | Recommendation |
|------|-------|-------------|------|----------------|
| Lamb mince 500g | £4.50 | £4.75 | £3.79 | Aldi |
| King prawns 200g | £4.00 | £4.50 | £3.49 | Aldi (if in stock) |
| Parmesan 100g | £3.00 | £2.80 | £2.29 | Aldi for value, Sainsbury's for quality |

**Recommendation:**
> "Aldi for proteins this week (save ~£2.50). They also have parmesan cheaper, but Sainsbury's/Tesco Parmigiano-Reggiano is noticeably better quality if you prefer. Rest of the shop at your usual store."
