# Nutrition Guidelines

Guidance for balanced meal planning across dietary phases. Other phases or diets can be added as required during onboarding.

## Dietary Phases

### Maintenance
- **Goal:** Stable weight, balanced nutrition
- **Approach:** Eat at maintenance calories, varied diet
- **Focus:** All food groups represented weekly

### Weight Loss
- **Goal:** Gradual, sustainable fat loss
- **Approach:** Moderate calorie deficit (300-500 kcal below maintenance)
- **Focus:** 
  - High protein to preserve muscle
  - High fibre for satiety
  - Reduce but don't eliminate carbs/fats
  - Avoid crash diets

### Weight Gain / Muscle Building
- **Goal:** Lean mass gain
- **Approach:** Moderate surplus (200-400 kcal above maintenance)
- **Focus:**
  - High protein (1.6-2.2g per kg bodyweight)
  - Adequate carbs for training
  - Time meals around activity

## Weekly Balance

Across a week of meals, aim for variety:

### Proteins
- 2-3 poultry dishes
- 1-2 fish/seafood dishes
- 1-2 vegetarian/plant-based dishes
- 0-1 red meat dishes (or more if preferred)

### Vegetables
- Different colours across the week (eat the rainbow)
- Mix of raw and cooked
- Aim for 5+ portions daily

### Carbohydrates
- Variety of sources: rice, pasta, bread, potatoes, grains
- Include wholegrains where possible
- Portion control for weight loss

### Fats
- Include healthy fats: olive oil, nuts, avocado, oily fish
- Moderate saturated fats
- Avoid trans fats

## Portion Guidance

### Standard Portions (per person)
| Food | Portion |
|------|---------|
| Meat/fish | 120-150g raw |
| Rice/pasta (dry) | 75-100g |
| Vegetables | 150-200g |
| Potatoes | 200-250g |
| Bread | 2 slices |
| Cheese | 30g |
| Oil for cooking | 1 tbsp |

### Adjustments
- **OMAD (one meal a day):** Double portions
- **Weight loss:** Reduce carb portions by 25%
- **High activity:** Increase carb portions by 25%
- **Multiple people:** Multiply base portions

## Calorie Estimates by Cuisine

Rough estimates for typical home-cooked portions:

| Cuisine | Light Dish | Medium Dish | Heavy Dish |
|---------|------------|-------------|------------|
| Thai | 400-500 kcal | 550-700 kcal | 700-900 kcal |
| Japanese | 350-450 kcal | 500-650 kcal | 650-800 kcal |
| Indian | 450-550 kcal | 600-800 kcal | 800-1000 kcal |
| Italian | 450-550 kcal | 600-800 kcal | 800-1000 kcal |
| Greek | 400-500 kcal | 550-700 kcal | 700-900 kcal |
| Mexican | 450-550 kcal | 600-800 kcal | 800-1000 kcal |

*These are estimates. Actual calories depend on ingredients and portions.*

## Red Flags

Alert the user if:
- Same cuisine 3+ times in a week (lack of variety)
- No vegetables in 2+ consecutive days
- No protein source in a meal
- All meals are "heavy" in a weight-loss phase
- Same protein source 4+ times in a week

## Special Considerations

### Vegetarian/Vegan Meals
- Ensure complete proteins (combine legumes + grains)
- Consider B12 (fortified foods or supplements)
- Iron sources: legumes, dark leafy greens, fortified cereals

### Low-Carb
- Focus on protein + vegetables + healthy fats
- Cauliflower rice, courgette noodles as substitutes
- Watch portion sizes on nuts/cheese

### High-Protein
- Lean meats, fish, eggs, Greek yogurt, legumes
- Can add protein powder to smoothies/oats
- Cottage cheese as snack option
