# Cuisine Guides

This folder contains research guides for authentic cuisine preparation.

## Structure

Each cuisine gets its own file:

```
cuisines/
├── README.md (this file)
├── thai.md
├── japanese.md
├── italian.md
├── indian.md
├── greek.md
├── vietnamese.md
├── mexican.md
├── korean.md
└── ... (added as researched)
```

## Per-Cuisine Template

Each file should include:

1. **Overview** — Brief cultural context
2. **Key Ingredients** — Pantry staples for this cuisine
3. **Key Techniques** — Common cooking methods
4. **Regional Variations** — Different styles within the cuisine
5. **Authentic Sources** — Where to find real recipes (not Westernised)
6. **Music** — Contemporary and classic artists/genres
7. **Cultural Events** — Associated festivals and celebrations
8. **Common Mistakes** — What to avoid
9. **Substitutions** — When authentic ingredients aren't available

## Research Guidelines

When researching a cuisine:

1. **Search in the original language** where possible
2. **Prioritise native sources** over English food blogs
3. **Note dietary traditions** (e.g., no beef in Hindu cuisines)
4. **Find actual music** from the region, not "world music" compilations
5. **Check contemporary culture** — what's popular now, not just traditional

## Building This Library

Cuisines are added as they're used. Each week's planning may add new research.

Don't try to complete this all at once — let it grow organically with real usage.
