# Assessment Administration Prompts

## GAD-7 (Generalized Anxiety Disorder — 7 items)

### Introduction
"I'd like to administer the GAD-7 — it's a 7-item anxiety screener developed by Spitzer, Kroenke, Williams, and Löwe in 2006. It measures generalized anxiety severity over the past two weeks. I'll ask you 7 questions, each rated 0 to 3."

### Scale
For each item: **0** = Not at all | **1** = Several days | **2** = More than half the days | **3** = Nearly every day

### Items
Over the last 2 weeks, how often have you been bothered by:
1. Feeling nervous, anxious, or on edge
2. Not being able to stop or control worrying
3. Worrying too much about different things
4. Trouble relaxing
5. Being so restless that it is hard to sit still
6. Becoming easily annoyed or irritable
7. Feeling afraid, as if something awful might happen

### Scoring & Interpretation
| Score | Severity | Clinical Action |
|-------|----------|-----------------|
| 0-4 | Minimal | Monitor |
| 5-9 | Mild | Monitor, reassess in 2 weeks |
| 10-14 | Moderate | Consider treatment; clinical cutoff for probable GAD |
| 15-21 | Severe | Active treatment warranted; consider professional referral |

Report: "Your GAD-7 score is {score}/21, which falls in the {severity} range. The clinical cutoff for probable Generalized Anxiety Disorder is 10. {comparison to previous if available}."

---

## PHQ-9 (Patient Health Questionnaire — 9 items)

### Introduction
"I'm going to administer the PHQ-9 — a 9-item depression screener developed by Kroenke, Spitzer, and Williams. It's the most widely used depression screening tool in clinical practice. Since anxiety and depression frequently co-occur, tracking both gives us a fuller picture."

### Scale
For each item: **0** = Not at all | **1** = Several days | **2** = More than half the days | **3** = Nearly every day

### Items
Over the last 2 weeks, how often have you been bothered by:
1. Little interest or pleasure in doing things
2. Feeling down, depressed, or hopeless
3. Trouble falling or staying asleep, or sleeping too much
4. Feeling tired or having little energy
5. Poor appetite or overeating
6. Feeling bad about yourself — or that you are a failure or have let yourself or your family down
7. Trouble concentrating on things, such as reading the newspaper or watching television
8. Moving or speaking so slowly that other people could have noticed? Or the opposite — being so fidgety or restless that you have been moving around a lot more than usual
9. Thoughts that you would be better off dead, or of hurting yourself

**⚠️ ITEM 9 CRITICAL:** Any response > 0 on item 9 triggers safety assessment per Crisis Protocol.

### Follow-up Question (required)
"If you checked off any problems, how difficult have these problems made it for you to do your work, take care of things at home, or get along with other people?"
- Not difficult at all
- Somewhat difficult
- Very difficult
- Extremely difficult

### Scoring & Interpretation
| Score | Severity | Clinical Action |
|-------|----------|-----------------|
| 0-4 | Minimal | None |
| 5-9 | Mild | Watchful waiting, repeat at follow-up |
| 10-14 | Moderate | Treatment plan; therapy indicated |
| 15-19 | Moderately Severe | Active treatment + consider professional referral |
| 20-27 | Severe | Immediate treatment + professional referral strongly recommended |

---

## DASS-21 (Depression Anxiety Stress Scales — 21 items)

### Introduction
"This is the DASS-21, a broader assessment that measures three dimensions: depression, anxiety, and stress separately. It was developed by Lovibond & Lovibond and gives us a more complete picture than anxiety-only measures. There are 21 statements — rate how much each applied to you over the past week."

### Scale
**0** = Did not apply to me at all
**1** = Applied to me to some degree, or some of the time
**2** = Applied to me to a considerable degree, or a good part of the time
**3** = Applied to me very much, or most of the time

### Items (with subscale key: D=Depression, A=Anxiety, S=Stress)

1. (S) I found it hard to wind down
2. (A) I was aware of dryness of my mouth
3. (D) I couldn't seem to experience any positive feeling at all
4. (A) I experienced breathing difficulty (e.g., excessively rapid breathing, breathlessness in the absence of physical exertion)
5. (D) I found it difficult to work up the initiative to do things
6. (S) I tended to over-react to situations
7. (A) I experienced trembling (e.g., in the hands)
8. (S) I felt that I was using a lot of nervous energy
9. (A) I was worried about situations in which I might panic and make a fool of myself
10. (D) I felt that I had nothing to look forward to
11. (S) I found myself getting agitated
12. (S) I found it difficult to relax
13. (D) I felt down-hearted and blue
14. (S) I was intolerant of anything that kept me from getting on with what I was doing
15. (A) I felt I was close to panic
16. (D) I was unable to become enthusiastic about anything
17. (D) I felt I wasn't worth much as a person
18. (S) I felt that I was rather touchy
19. (A) I was aware of the action of my heart in the absence of physical exertion (e.g., sense of heart rate increase, heart missing a beat)
20. (A) I felt scared without any good reason
21. (D) I felt that life was meaningless

### Scoring
Multiply each subscale total by 2 (to match the full DASS-42 norms).

| Subscale | Normal | Mild | Moderate | Severe | Extremely Severe |
|----------|--------|------|----------|--------|-----------------|
| Depression | 0-9 | 10-13 | 14-20 | 21-27 | 28+ |
| Anxiety | 0-7 | 8-9 | 10-14 | 15-19 | 20+ |
| Stress | 0-14 | 15-18 | 19-25 | 26-33 | 34+ |

---

## PCL-5 (PTSD Checklist — 20 items)

### Introduction
"This is the PCL-5, a 20-item PTSD assessment based on DSM-5 criteria. It was developed by Weathers and colleagues at the VA National Center for PTSD. I'll ask about experiences related to a stressful event. Rate how much each has bothered you in the past month."

### Scale
**0** = Not at all | **1** = A little bit | **2** = Moderately | **3** = Quite a bit | **4** = Extremely

### Items
In the past month, how much were you bothered by:

**Cluster B — Intrusion (items 1-5)**
1. Repeated, disturbing, and unwanted memories of the stressful experience
2. Repeated, disturbing dreams of the stressful experience
3. Suddenly feeling or acting as if the stressful experience were actually happening again (as if you were actually back there reliving it)
4. Feeling very upset when something reminded you of the stressful experience
5. Having strong physical reactions when something reminded you of the stressful experience (e.g., heart pounding, trouble breathing, sweating)

**Cluster C — Avoidance (items 6-7)**
6. Avoiding memories, thoughts, or feelings related to the stressful experience
7. Avoiding external reminders of the stressful experience (e.g., people, places, conversations, activities, objects, or situations)

**Cluster D — Negative Cognition/Mood (items 8-14)**
8. Trouble remembering important parts of the stressful experience
9. Having strong negative beliefs about yourself, other people, or the world (e.g., having thoughts such as: I am bad, there is something seriously wrong with me, no one can be trusted, the world is completely dangerous)
10. Blaming yourself or someone else for the stressful experience or what happened after it
11. Having strong negative feelings such as fear, horror, anger, guilt, or shame
12. Loss of interest in activities that you used to enjoy
13. Feeling distant or cut off from other people
14. Trouble experiencing positive feelings (e.g., being unable to feel happiness or have loving feelings for people close to you)

**Cluster E — Arousal/Reactivity (items 15-20)**
15. Irritable behavior, angry outbursts, or acting aggressively
16. Taking too many risks or doing things that could cause you harm
17. Being "superalert" or watchful or on guard
18. Feeling jumpy or easily startled
19. Having difficulty concentrating
20. Trouble falling or staying asleep

### Scoring & Interpretation
| Score | Interpretation |
|-------|---------------|
| 0-30 | Below threshold |
| 31-33 | Provisional PTSD diagnosis cutoff |
| 34+ | Probable PTSD (sensitivity 89% at 34) |

**DSM-5 Cluster scoring:** Can also assess by cluster — need ≥1 Cluster B, ≥1 Cluster C, ≥2 Cluster D, ≥2 Cluster E items rated ≥2 for provisional diagnosis.

---

## Quick Differential Diagnosis Screen

When the primary disorder isn't clear, use this conversational screening sequence:

1. "Do you worry about many different things most days, or is your anxiety focused on specific situations?" → GAD vs specific
2. "Have you ever had a sudden rush of intense fear that peaks within minutes — heart pounding, can't breathe, feeling like you might die?" → Panic
3. "Is most of your anxiety about social situations — being judged, embarrassed, or humiliated?" → Social Anxiety
4. "Do you get unwanted thoughts that keep coming back — about contamination, harm, symmetry, or things being 'just right'?" → OCD obsessions
5. "Do you feel driven to do certain behaviors repeatedly to reduce anxiety — checking, washing, counting, ordering?" → OCD compulsions
6. "Have you experienced a traumatic event — violence, accident, assault, combat, or witnessed something horrifying — that still affects you?" → PTSD
7. "Does the anxiety come in sudden waves that pass, or is it more of a constant background hum?" → Panic (waves) vs GAD (constant)

Based on responses, administer the appropriate disorder-specific instrument or proceed with transdiagnostic assessment (DASS-21).
