# FearBot 🧠

**CBT-based therapy for anxiety, depression, stress & trauma**

[![OpenClaw](https://img.shields.io/badge/OpenClaw-2026.1.0+-blue)](https://openclaw.ai)
[![License](https://img.shields.io/badge/License-MIT-green)](LICENSE)

---

## What is FearBot?

FearBot turns your OpenClaw agent into a structured CBT (Cognitive Behavioral Therapy) companion for the full spectrum of common mental health concerns. It provides:

- 📊 **Validated Assessments** — GAD-7, PHQ-9, DASS-21, PCL-5 with clinical scoring
- 🔍 **Differential Diagnosis** — Screens for anxiety, depression, panic, OCD, PTSD
- 📝 **Session Tracking** — Persistent history, mood logs, homework assignments  
- 💭 **Thought Records** — Quick logging for any distressing moment
- 🚨 **Crisis Detection** — Three-tier safety system with automatic escalation
- 🧠 **CBT Techniques** — Cognitive restructuring, behavioral activation, exposure, grounding

## The Context Advantage

Traditional therapy apps don't know your life. FearBot works best with a fully-integrated OpenClaw agent that already has context from your daily messages, work stress, relationships, and everything in between.

**No cold start. No "catch me up." Your agent already knows your week.**

## ⚠️ Important

**This is NOT a replacement for professional mental health care.**

- For serious concerns, see a qualified professional
- If in crisis, contact emergency services or a crisis helpline
- Designed for mild-to-moderate anxiety, depression, stress, and trauma
- Not for: active suicidality, psychosis, severe depression, eating disorders, bipolar

## Quick Start

1. Install the skill
2. Say "therapy mode" or "fearbot" to your agent
3. Complete the intake assessment
4. Continue with regular sessions

## Activation Phrases

- `therapy mode` / `start therapy` / `therapy session`
- `fearbot` / `fear bot`
- `I'm anxious` (for quick thought record)

## Data Privacy

All therapy data stays LOCAL on your machine:
- Sessions, assessments, thought records — all in `~/clawd/data/therapy/`
- Nothing sent to external servers
- Your mental health data is yours alone

## Requirements

- OpenClaw 2026.1.0+
- Bash shell
- jq (JSON processor)

## Credits

- CBT framework: Aaron Beck's cognitive model
- Assessments: GAD-7, PHQ-9, DASS-21, PCL-5 (validated instruments)
- Crisis protocol: Columbia Suicide Severity Rating Scale

## License

MIT — Use freely, help freely.

---

*Built by someone with anxiety, for people with anxiety.*
