---
name: fastmail
description: Manages Fastmail email and calendar via JMAP and CalDAV APIs. Use for emails (read, send, reply, search, organize, bulk operations, threads) or calendar (events, reminders, RSVP invitations). Timezone auto-detected from system.
compatibility: opencode
metadata:
  author: witooh
  version: "2.1"
  api: JMAP, CalDAV
---

## Quick Start

Invoke tools via CLI:

```bash
# Install dependencies first
cd .opencode/skills/fastmail && bun install

# Email: List mailboxes
bunx fastmail list_mailboxes

# Email: Send
bunx fastmail send_email \
  '{"to": [{"email": "user@example.com"}], "subject": "Hi", "text_body": "Message"}'

# Calendar: List events
bunx fastmail list_events \
  '{"start_date": "2024-01-01", "end_date": "2024-01-31"}'

# Calendar: Create event with reminder
bunx fastmail create_event_with_reminder \
  '{"title": "Meeting", "start": "2024-01-15T10:00:00", "end": "2024-01-15T11:00:00", "reminder_minutes": [15, 60]}'

# List all available tools
bunx fastmail --list
```

## When to Use This Skill

- 📧 Check inbox or search emails
- 📧 Send, reply, or move emails
- 🏷️ Apply labels or organize mailbox
- 📅 View calendar or events
- 📅 Create, update, or delete events
- 🔔 Set event reminders or alarms

## Email Tools (10 total)

| Tool | Purpose |
|------|---------|
| `list_mailboxes` | List all folders |
| `list_emails` | List emails in mailbox |
| `get_email` | Get full email content |
| `get_thread` | Get all emails in a conversation thread |
| `search_emails` | Search by text query |
| `send_email` | Send new email |
| `reply_email` | Reply to email |
| `move_email` | Move to folder |
| `set_labels` | Apply labels ($seen, $flagged) |
| `delete_email` | Delete (move to trash) |

## Bulk Email Tools (3 total)

| Tool | Purpose |
|------|---------|
| `bulk_move_emails` | Move multiple emails at once |
| `bulk_set_labels` | Apply labels to multiple emails |
| `bulk_delete_emails` | Delete multiple emails at once |

## Calendar Tools (10 total)

| Tool | Purpose |
|------|---------|
| `list_calendars` | List all calendars |
| `list_events` | List events by date range |
| `get_event` | Get event details |
| `create_event` | Create new event |
| `update_event` | Update existing event |
| `delete_event` | Delete event |
| `search_events` | Search by title/description |
| `create_recurring_event` | Create repeating event |
| `list_invitations` | List calendar invitations |
| `respond_to_invitation` | Accept/decline/maybe invitations |

## Reminder Tools (4 total)

| Tool | Purpose |
|------|---------|
| `add_event_reminder` | Add reminder to event |
| `remove_event_reminder` | Remove reminder(s) |
| `list_event_reminders` | List reminders for event |
| `create_event_with_reminder` | Create event + reminder in one call |

## Common Examples

```bash
# Check inbox (limit 10)
bunx fastmail list_emails '{"limit": 10}'

# Search for emails
bunx fastmail search_emails '{"query": "invoice"}'

# Get specific email content
bunx fastmail get_email '{"email_id": "xxx"}'

# Get email thread/conversation
bunx fastmail get_thread '{"email_id": "xxx"}'

# Bulk operations
bunx fastmail bulk_move_emails '{"email_ids": ["id1", "id2"], "target_mailbox_id": "archive"}'
bunx fastmail bulk_delete_emails '{"email_ids": ["id1", "id2", "id3"]}'

# Create recurring event (daily for 10 days)
bunx fastmail create_recurring_event \
  '{"title": "Standup", "start": "2024-01-01T09:00:00", "end": "2024-01-01T09:30:00", "recurrence": "daily", "recurrence_count": 10}'

# Calendar invitations
bunx fastmail list_invitations
bunx fastmail respond_to_invitation '{"event_id": "xxx", "response": "accept"}'
```

## Decision Tree

**Need to manage email?**
- List/search → `list_emails` or `search_emails`
- Read content → `get_email`
- View conversation → `get_thread`
- Send/reply → `send_email` or `reply_email`
- Organize → `move_email`, `set_labels`, `delete_email`
- Bulk actions → `bulk_move_emails`, `bulk_set_labels`, `bulk_delete_emails`

**Need to manage calendar?**
- View → `list_calendars` or `list_events`
- Create → `create_event` or `create_recurring_event`
- Modify → `update_event`
- Delete → `delete_event`
- Invitations → `list_invitations`, `respond_to_invitation`

**Need reminders?**
- Add to existing event → `add_event_reminder`
- Create event + reminder → `create_event_with_reminder` (faster)
- Manage → `list_event_reminders`, `remove_event_reminder`

## Output Format

All tools return JSON:

```json
{
  "success": true,
  "data": { /* tool-specific response */ },
  "timestamp": "2024-01-15T10:00:00+07:00"
}
```

## Environment Variables

| Variable | Purpose | Required |
|----------|---------|----------|
| `FASTMAIL_API_TOKEN` | Email via JMAP | Yes (for email) |
| `FASTMAIL_USERNAME` | Calendar via CalDAV | Yes (for calendar) |
| `FASTMAIL_PASSWORD` | Calendar app password | Yes (for calendar) |
| `FASTMAIL_TIMEZONE` | Calendar timezone (IANA format) | No (auto-detected) |

**Setup:**
```bash
export FASTMAIL_API_TOKEN="your-api-token"
export FASTMAIL_USERNAME="your-email@fastmail.com"
export FASTMAIL_PASSWORD="your-app-password"
# Optional: Override timezone (defaults to system local timezone)
export FASTMAIL_TIMEZONE="America/New_York"  # or "Asia/Bangkok", "Europe/London", etc.
```

## Timezone Support

⏰ **Configurable calendar timezone**
- **Default:** Auto-detects your system's local timezone
- **Override:** Set `FASTMAIL_TIMEZONE` environment variable
- Uses IANA timezone identifiers (e.g., `America/New_York`, `Asia/Bangkok`, `Europe/London`)
- Input times assumed in configured timezone
- Output times shown in configured timezone
- Stored internally as UTC
- Handles Daylight Saving Time (DST) automatically

## See Also

- **Detailed reference:** `.opencode/skills/fastmail/references/TOOLS.md`
- **Full guide:** `.opencode/skills/fastmail/README.md`
- **Setup help:** Fastmail Settings → Privacy & Security → Integrations
