# Fasting Safety Guidelines

Reference only — critical safety information.

## Who Should NOT Fast
- **Pregnancy/breastfeeding** — nutritional demands too high
- **Eating disorders** (current or history) — can trigger relapse; if this applies, redirect to NEDA helpline (1-800-931-2237) or therapist
- **Type 1 diabetes** — hypoglycemia/DKA risk
- **Type 2 diabetes on insulin/sulfonylureas** — hypoglycemia can be life-threatening
- **Underweight** (BMI <18.5) — insufficient reserves
- **Children/adolescents** — still growing
- **Unstable medical conditions**
- **Gallbladder issues** — fasting increases gallstone risk

## Consult Doctor First
- **Type 2 diabetes on metformin:** Lower hypo risk than insulin, but discuss timing
- **Type 2 diabetes on insulin/sulfonylureas:** HIGH hypo risk — needs supervision
- Heart, kidney, or liver disease
- Over 65 years old
- Taking medications (blood thinners, BP meds, diabetes meds — timing matters)

## Diabetic-Specific Notes
- Monitor blood glucose before/during fasts if diabetic
- Break fast if BG drops below 70 mg/dL
- Metformin: usually take with food — discuss timing with pharmacist
- Dawn phenomenon may affect morning readings

## When to STOP Fasting
- Dizziness or fainting
- Severe headaches
- Heart palpitations
- Extreme weakness
- Confusion or disorientation
- Signs of hypoglycemia (shaking, sweating)

## Extended Fast Safety (24h+)
- **Electrolytes** — supplement sodium, potassium, magnesium
- **Hydration** — water, black coffee, plain tea OK
- **Exercise** — light activity only, no intense workouts
- **Breaking fast** — start small, avoid heavy meals

## Refeeding (5+ day fasts)
- Reintroduce food SLOWLY
- Start with broth, then soft foods
- Avoid large meals for first 24-48h
- Monitor for bloating, discomfort

## Religious/Dry Fasting (Ramadan)
- No water = higher dehydration risk
- Shorter fasting hours in summer can still be intense
- Break immediately if severe symptoms
- Exemptions exist for illness, travel, menstruation — respect them

## Agent Behavior
- Never encourage fasting beyond stated goal
- Extended fasts: check in every 12-24h
- If symptoms mentioned → suggest breaking fast
- If ED mentioned → stop tracking, redirect to help
- Always defer to medical advice
