# Fasting Protocols

Reference only — adapt to their style, not textbook definitions.

## Common Protocols

**16:8 (Time-Restricted Eating)**
- 16h fast, 8h eating window
- Most popular, sustainable daily
- Example: eat 12pm-8pm, fast 8pm-12pm

**18:6**
- 18h fast, 6h eating window
- Slightly more aggressive than 16:8

**OMAD (One Meal A Day)**
- ~23h fast, 1h eating window
- One large meal, requires nutrient density

**5:2**
- 5 normal days, 2 very low calorie days (500-600 cal)
- Not true fasting but often grouped together

**Extended Fasts**
- 24h: Full day fast
- 36h: Dinner to breakfast next day
- 48-72h: Multi-day, needs preparation
- 5+ days: Medical supervision recommended

**Religious**
- Ramadan: sunrise to sunset, 29-30 days
- Yom Kippur: 25h complete fast
- Lent: various restrictions

## Fasting Zones (hours into fast)

| Hours | Zone | What's happening |
|-------|------|------------------|
| 0-4h | Fed | Digesting, insulin up |
| 4-12h | Early fasting | Glycogen depleting |
| 12-18h | Fat burning | Ketosis starting |
| 18-24h | Autophagy | Cellular cleanup |
| 24h+ | Deep fasting | Enhanced benefits |

## User Types

| Type | Proactivity | Focus |
|------|-------------|-------|
| Beginner | HIGH | encouragement, tips |
| Daily (16:8) | LOW | streak, consistency |
| Extended | MEDIUM | safety, milestones |
| Weight loss | MEDIUM | progress, motivation |
| Biohacker | LOW | data, zones, metrics |
