---
name: fasting-tracker
description: Track intermittent fasting windows, extended fasts, and autophagy milestones
author: clawd-team
version: 1.0.0
triggers:
  - "start fast"
  - "fasting timer"
  - "break my fast"
  - "fasting progress"
  - "how long fasting"
---

# Fasting Tracker

Monitor intermittent and extended fasting with precision—track eating windows, metabolic phases, and autophagy milestones in real-time.

## What it does

- **Fast Timer**: Start a fast and get real-time elapsed tracking with countdown to key metabolic milestones
- **Eating Window Tracking**: Log when you break your fast and automatically calculate your eating window duration
- **Metabolic Milestones**: Receive alerts at ketosis (12h), fat adaptation (16h), autophagy (24h), and deeper cellular renewal thresholds
- **Smart History**: Review past fasts with duration, eating windows, and consistency metrics

## Usage

### Start Fast
"Start a fast" or "begin fasting"
- Logs the fast start time
- Displays current time and target milestones
- Sets background tracking (runs even when you close the app)

### Break Fast
"Break my fast" or "I'm eating now"
- Records the end time
- Calculates total fast duration
- Shows eating window recommendation and next fast opportunity

### Check Timer
"How long have I been fasting?" or "fasting status"
- Displays elapsed time
- Shows next metabolic milestone and time remaining
- Displays current autophagy phase if applicable

### Fast History
"My fasting stats" or "fasting progress"
- Lists recent fasts with duration
- Shows weekly consistency
- Displays longest streak and average fast length

### Set Schedule
"Schedule my fasts" or "fasting protocol"
- Configure preferred fasting protocol (16:8, OMAD, etc.)
- Set daily reminders for fast start/end times
- Customize notifications for key milestones

## Metabolic Timeline

| Duration | Milestone | Status |
|----------|-----------|--------|
| 12 hours | **Ketosis Begins** | Glycogen depletes; body shifts to fat burning |
| 16 hours | **Fat Adaptation** | Insulin drops further; metabolic efficiency improves |
| 24 hours | **Autophagy Activation** | Cellular cleanup intensifies; damaged proteins recycled |
| 36 hours | **Deep Autophagy** | Mitochondrial renewal accelerates; immune reset begins |
| 48 hours | **Cellular Regeneration** | Growth hormone peaks; stem cell activation (rodent studies) |
| 72+ hours | **Extended Benefits** | Sustained autophagy; metabolic recalibration; requires medical oversight |

## Fasting Protocols

- **16:8 Intermittent**: 16-hour fast, 8-hour eating window (most beginner-friendly)
- **18:6 Intermediate**: 18-hour fast, 6-hour eating window (moderate difficulty)
- **20:4 Warrior**: 20-hour fast, 4-hour eating window (lean gains focus)
- **OMAD** (One Meal A Day): 23-hour fast, 1-hour eating window (advanced)
- **24-Hour Fast**: Full day fast (once or twice weekly)
- **Extended Fast**: 36–72+ hours (consult healthcare provider; requires electrolyte management)

## Tips

- **Electrolytes Matter**: Extended fasts deplete sodium, potassium, and magnesium. Supplement or drink bone broth to prevent cramping and fatigue.
- **Hydration is Essential**: Water, herbal tea, black coffee, and green tea are fasting-friendly; any calorie breaks the fast.
- **Listen to Your Body**: Fatigue, dizziness, or intense hunger warrants eating—fasting should enhance, not impair, daily function.
- **Consistency Beats Intensity**: A sustainable 16:8 protocol done for months outpaces sporadic 72-hour fasts; build the habit first.
- **All data stays local on your machine**: Your fasting logs, schedules, and metrics never leave your device—complete privacy, no cloud sync required.
