# User-Specific Guidance — Fashion

## Plus-Size Users

### Brand Size Ranges (Know These)
| Brand | Max Size | Notes |
|-------|----------|-------|
| Eloquii | 32 | Designed FOR plus bodies |
| Universal Standard | 40 | True extended range |
| Torrid | 6X | Good for younger styles |
| ASOS Curve | 26 | Wide selection |
| Girlfriend Collective | 6XL | Athletic wear |

### Key Rules
- Ask WHERE they carry weight — same size, different needs
- Stylish ≠ "flattering" (reject hide-your-body defaults)
- Warn about grading issues — some brands just scale up patterns
- Know hard-to-find categories: swimwear, formalwear, structured blazers

---

## Petite Users (Under 5'3" / 160cm)

### Length Translation
| Standard Term | Petite Reality |
|---------------|----------------|
| Midi skirt | Hits at/below ankle |
| Cropped pants | Full-length (26-27" inseam) |
| 3/4 sleeve | Full-length sleeve |
| Maxi dress | Pooling on floor |

### Key Rules
- Always specify inseam/hem in inches, not style names
- Ask about torso vs leg proportion — changes everything
- ONE volume zone only (oversized top + slim bottom, not both)
- Know which brands have true petite sizing vs just XS

---

## Men Seeking Style Help

### What Men Actually Need
- **Specific formulas**: "Navy chinos + white oxford + tan boots" not "timeless basics"
- **Fit landmarks**: Where shoulder seams should hit, how much sleeve shows
- **"One notch up" calibration**: Better than peers without triggering "job interview?" comments
- **Progression path**: Starter wardrobe → intermediate → advanced

### Fit Checkpoints
- Shoulder seam hits at bone edge (not off shoulder)
- Two fingers between collar and neck
- Shirt hem covers belt but not crotch
- Pants break: slight (modern) to full (traditional)

### Frame Style As
- Competence and credibility, not attractiveness
- "Look like you have your shit together"
- Practical self-improvement, not fashion enthusiasm

---

## Parents with Young Kids

### Fabric Priorities
| Challenge | Solution Fabrics |
|-----------|------------------|
| Spit-up | Heathered grays, olive |
| Food stains | Dark prints, burgundy |
| Playground dirt | Dark wash denim, black |

### Key Rules
- Machine wash or nothing — no dry clean
- No chunky jewelry (kids grab it)
- Must pass "squat and chase" test
- Nursing access if needed (button-downs, wrap styles)
- Give ONE answer when they have 2 minutes

---

## Frequent Travelers

### Fabric Filtering
- ✅ Merino wool, ponte, technical blends, travel-grade cotton
- ❌ Linen (wrinkles), 100% cotton dress shirts, silk, velvet

### Packing Rules
- Schedule → outfit mapping (not "versatile options")
- Same-audience tracking (don't repeat for same clients)
- 40% must be sink-washable for trips >3 days
- Layer systems for climate swings

---

## Budget-Constrained Users

### Thrift Strategy
- Search specific keywords on Vinted/Depop, not browse
- Check: armpit stains, crotch wear, zipper quality
- Know what's worth tailoring vs passing
- Goodwill Outlet bins vs curated vintage pricing

### Emergency Resources
- Church clothing closets, Dress for Success
- Buy Nothing groups
- Borrow scripts for friends/family

### Cost-Per-Wear Math
| Item Type | Target CPW |
|-----------|------------|
| Trend piece | <€5/wear |
| Work basics | <€5/wear |
| Investment piece | <€3/wear |

---

## Adaptive Clothing Needs

### Critical Questions
- Closure type requirements (magnetic, velcro, pull-on only)
- Medical device locations needing access
- Seated vs standing proportions
- Dexterity limitations

### Seated Body Considerations
- Tops: longer in back (riding up when seated)
- Pants: higher back rise, no hip-crease bunching
- Hemlines: must clear wheels with margin

### "Dressing Effort" Assessment
Include energy cost — chronic illness means limited capacity. Low-effort alternatives should always be offered.

---

## Gender-Diverse Users

### Critical Distinctions
- **Passing**: Silhouette camouflage, safety-focused
- **Expressing**: Authentic visibility, celebrating identity
- Ask which goal — never assume

### Safe Guidance
- Binding: NEVER ACE bandages. Direct to gc2b, Underworks, Spectrum
- Include 8-hour limits, harm signs
- Tucking: proper gaffs, when NOT to tuck

### Inclusive Brands
Actually inclusive: TomboyX, Wildfang, Kirrin Finch
Good unisex: Uniqlo, COS, & Other Stories

---

## Older Adults (55+)

### Priorities
- Comfort-first filtering WITHOUT frumpiness
- Natural fabrics that breathe (hot flashes)
- Shoes with actual support
- Age-specific color guidance (skin tone shifts)

### Update vs Replace
- Help style existing quality pieces in current ways
- Honest "dated vs classic" assessment
- Respect investment in wardrobe, just refresh styling

---

## Non-Western Cultural Contexts

### Key Awareness
- Traditional-modern fusion (saree with contemporary blouse)
- Modesty as mainstream, not niche
- Regional dress code variations (Indian wedding ≠ Western wedding)
- Local brand knowledge (not just Zara/H&M)

### Climate Reality
- Don't suggest wool for 35°C humidity
- Monsoon-appropriate fabrics and footwear
- Most of the world doesn't have "four seasons"

---

## Fashion Minimalists

### Rules for Anti-Fashion Users
- ONE answer, not options
- Lock their "uniform" and stop suggesting variations
- Exact-item replenishment, zero research
- Minimum delta for occasion overrides
- Anti-shopping guardrails (refuse trend discussions)
