# Styling Fundamentals — Fashion

## Proportion Rules

### The 1/3-2/3 Principle
Divide outfit visually into thirds:
- Cropped top + high-waisted pants = 1/3 top, 2/3 bottom (elongates legs)
- Tucked blouse + midi skirt = inverted ratio

### Visual Weight Distribution
| Goal | Strategy |
|------|----------|
| Balance wide hips | Shoulder emphasis, structured tops |
| Balance broad shoulders | A-line skirts, wide-leg pants |
| Elongate frame | Monochromatic, vertical lines, V-necks |

### Breaking Rules Intentionally
Oversized everything (90s revival) breaks proportion deliberately. Know the rules so you can break them KNOWINGLY.

---

## Silhouette Vocabulary

Describe garment SHAPE before color/print:
- **A-line vs column vs fit-and-flare**
- **Drop waist vs empire vs natural waist**
- **Raglan vs set-in vs dropped shoulder sleeves**

Construction determines flattering — pattern is secondary.

---

## Color Through Undertones

### Determine First
Ask: warm, cool, or neutral undertone?
- Warm: gold jewelry flatters, veins appear green
- Cool: silver jewelry flatters, veins appear blue
- Neutral: both work

### Filter All Color Advice
Navy isn't "universally flattering" — depends on undertone. Certain colors wash out cool undertones, others make warm undertones look sallow.

---

## Outfit Formulas

When overwhelmed, reduce to formulas:
| Context | Formula |
|---------|---------|
| Client meeting | Dark denim + white shirt + camel coat |
| Smart casual | Ankle pants + loafers + cashmere sweater |
| Weekend elevated | Wide-leg jeans + quality tee + blazer |

Help users identify 3-5 "uniforms" for their common contexts.

---

## Completing an Outfit

Most outfits fail at finishing touches. Always prompt:
- **Shoes?** (height changes silhouette balance)
- **Bag?** (proportion to body matters)
- **Jewelry?** (one statement OR quiet coordination)
- **Outerwear?** (must work with silhouette underneath)

---

## Aesthetic Distinctions

These are NOT synonyms:

| Aesthetic | Key Codes |
|-----------|-----------|
| Old Money | Inherited-wealth signals: Barbour, loafers, no visible logos, worn-in quality |
| Quiet Luxury | Wealthy minimalism: The Row, Loro Piana, neutral palette, perfect fit |
| Stealth Wealth | Tech-money disguise: Patagonia vest, premium basics, no signaling |
| Mob Wife | Loud luxury: fur, gold, red lips, animal print, logos visible |
| Clean Girl | No-makeup makeup, slicked hair, neutral palette, "effortless" grooming |
| Coastal Grandmother | Relaxed elegance: linen, white, Nancy Meyers movie vibes |

### Regional Variations
"Old money" differs by geography:
- **US**: Ralph Lauren, Nantucket, boat shoes
- **UK**: Barbour, Hunter boots, shabby chic
- **Italian**: Loro Piana, quiet tailoring, Portofino vibes

---

## Era Accuracy

When referencing decades, be specific:
| Era | Distinct Variations |
|-----|---------------------|
| 70s | Early (YSL peasant, folklore) vs Late disco (Halston) vs Punk (Westwood) |
| 80s | Power dressing (Armani shoulders) vs New Wave vs Preppy |
| 90s | Minimalism (Helmut Lang) vs Grunge (flannel, Doc Martens) |

Geographic context matters: London punk ≠ NYC punk ≠ LA punk.

---

## Designer DNA

When referencing designers, cite SPECIFIC eras:
- **Phoebe Philo at Céline (2008-2017)**: Power through restraint, architectural volumes
- **Margiela (1989-2009)**: Deconstruction, white lab coat, anonymity
- **The Row**: Stealth wealth, American ease, investment pieces

"Minimalist" alone is meaningless — specify WHOSE minimalism.

---

## Trend Lifecycle

| Phase | Signal | Action |
|-------|--------|--------|
| Emerging | 2-3 runway shows | Note for early adopters only |
| Ascending | Street style adoption | Safe to recommend |
| Peak | Fast fashion saturation | Warn it's "over" for trendsetters |
| Declining | Ironic use only | Avoid recommending |

Always state which phase when discussing trends.
