# Shopping Intelligence — Fashion

## Cross-Brand Sizing Reality

| Brand Category | Sizing Tendency |
|----------------|-----------------|
| US brands (Gap, J.Crew) | Vanity sized (+2" on labels) |
| Zara | Runs 1-2 sizes small |
| H&M | True to size or slightly large |
| French brands (Sezane, APC) | Run small |
| Scandinavian (COS, Arket) | Generous, relaxed fit |
| Italian (Max Mara) | Runs small, especially shoulders |
| Asian brands (Uniqlo) | Smaller cuts, shorter lengths |

**Always ask**: What's their fit in brands they already wear?

---

## Price Intelligence

### Brands That Never Discount
Lululemon, Hermès, Chanel, Apple — waiting for sales is futile.

### Predictable Sale Cycles
| Event | When | Typical Discount |
|-------|------|------------------|
| End of Season | Jan/July | 40-70% off |
| Black Friday | Late Nov | 20-40% off |
| Nordstrom Anniversary | July | 30-40% off |
| Prime Day | July | Variable |
| Memorial/Labor Day | May/Sept | 20-30% off |

### Price Red Flags
- "Was $200, Now $50" — item may have NEVER sold at $200
- Perpetual "sale" items — not actually discounted
- MSRP on DTC brands — they invented the "original" price

---

## Optimal Purchase Timing

| Item | Best Time | Reasoning |
|------|-----------|-----------|
| Winter coats | February | End of season, full selection |
| Swimwear | September | Season ending |
| Back-to-school | October | Post-rush clearance |
| Wedding guest outfit | 2+ months before | Alterations time |
| Basics | Anytime | No seasonal pressure |

---

## Return Policy Intelligence

### Common Gotchas
- "Free returns" may deduct shipping from refund
- Final sale = no returns (common on sale items)
- Some brands have 30-day windows vs 60-90 elsewhere
- Tags must be attached — inspect BEFORE removing

### Questions to Check
- Exchanges vs returns (often different policies)
- Store credit vs refund
- Sale item restrictions
- Receipt requirements

---

## Cost-Per-Wear Framework

| Item Type | Expected Wears | CPW Target |
|-----------|----------------|------------|
| Statement piece | 5-10 | <$20/wear |
| Trend item | 10-20 | <$5/wear |
| Work basics | 50-100 | <$5/wear |
| Investment pieces | 100+ | <$3/wear |
| Occasion wear | 2-5 | Consider rental |

**Formula**: (Price + Care Costs) ÷ Expected Wears = CPW

---

## Secondhand Strategy

### Platform Hierarchy
1. **Vinted** — Europe-strong, good prices
2. **Depop** — Younger brands, vintage
3. **ThredUp** — US, large selection
4. **Vestiaire Collective** — Designer, authenticated
5. **The RealReal** — Luxury, authenticated
6. **eBay** — Widest selection, requires filtering

### Thrift Store Tips
- Check: armpit stains, crotch wear, zipper quality
- Know what's worth tailoring vs passing
- Seasonal timing matters
- Goodwill Outlet bins = lowest prices, most digging

### Search Strategy
Search by: brand + item name + size + color
Don't just browse — targeted searching works better

---

## Sustainability Buying Hierarchy

Before ANY new purchase, consider in order:
1. Can they style something they own differently?
2. Can they borrow or rent it?
3. Can they find it secondhand?
4. Only then: ethical new purchase

### Certification Guide
| Real Certifications | Marketing Buzzwords |
|---------------------|---------------------|
| GOTS | "Conscious collection" |
| OEKO-TEX | "Eco-friendly" |
| B Corp | "Sustainable materials" |
| Fair Trade | "Green" |

---

## Ethical Brand Tiers by Region

| Region | Accessible | Mid-Range | Premium |
|--------|------------|-----------|---------|
| Global | Pact, Kotn | Patagonia | Stella McCartney |
| Europe | Armed Angels, Thought | Arket, COS | Gabriela Hearst |
| US | Girlfriend Collective | Eileen Fisher | The Row |
| UK | People Tree | Toast | Mother of Pearl |

---

## Budget-Constrained Shopping

### Maximize Impact
1. Replace worst 3 items first
2. Versatility > trendiness
3. Neutral colors stretch further
4. Quality outerwear + shoes first (daily visibility)

### DIY Value Adds
- Steam/iron everything (wrinkles = cheap look)
- Replace cheap buttons ($2 at fabric store)
- Hem pants properly (iron-on tape works)
- Lint roller religiously

### What to AVOID Buying Cheap
- Shoes (visible quality, daily wear)
- Outerwear (daily visibility)
- Anything shiny/synthetic that shows wrinkles

---

## The "One Wrong Purchase" Guardrail

Before ANY purchase over $20:
- [ ] Do I have 3+ things to wear this with RIGHT NOW?
- [ ] Am I buying because I'm stressed/bored/emotional?
- [ ] Will I wear this 30+ times?
- [ ] What's the cost-per-wear math?

If can't answer yes to all → wait 48 hours, then decide.
