# Occasion Dressing — Fashion

## Dress Code Decoding

### Business Dress Codes by Context

| Code | Tech Startup | Finance | Law | Creative Agency |
|------|--------------|---------|-----|-----------------|
| Business Professional | Rarely exists | Full suit, conservative | Full suit | Structured + personality |
| Business Casual | Jeans + blazer optional | Slacks + blazer, no tie | Dress pants + blazer | Almost anything elevated |
| Casual | Literally anything | Still means tucked shirt | Jeans OK, polished | Full creative expression |

**Rule**: Always ask industry AND company culture before interpreting.

---

## Event-Specific Guidance

### Wedding Guest
**Before recommending, ask:**
- Indoor/outdoor? (heel-sinking grass, beach sand)
- Religious venue? (shoulder coverage, head covering)
- Time of day? (evening = more formal)
- Wedding party colors? (avoid matching)

**Hard rules:**
- Never white/ivory/cream (bride territory)
- Never more formal than the wedding party
- Plan for photography (avoid strobing patterns, pure white, overly shiny)

### Job Interview
**Before recommending, ask:**
- Industry culture (startup vs corporate vs creative)
- Role level (entry vs executive)
- Video or in-person?

**Rule**: One notch above company norm. Overdressing can hurt in casual cultures.

### Presentation/Speaking
**Considerations:**
- Stage lighting washes out certain colors
- Movement — will outfit shift during gestures?
- Cameras — patterns can strobe
- Backup plan for wardrobe malfunctions

### Funeral
**Cultural variations:**
- Western: Black standard
- Some Asian cultures: White
- Some African cultures: Specific colors
- Always ask cultural context

---

## Venue Hazard Assessment

| Venue Type | Hazards | Solutions |
|------------|---------|-----------|
| Outdoor grass | Heels sink | Wedges, block heels, flats |
| Beach | Sand, wind | Skip heels entirely, secure hair |
| Religious sites | Coverage requirements | Carry wrap/cardigan |
| All-day events | Standing fatigue | Comfortable shoes, no new shoes |
| Dancing events | Movement constraints | Stretch fabrics, secure straps |

---

## Photography Considerations

### What Works on Camera
- Saturated colors (not pastels)
- Matte textures
- Defined silhouettes
- Solid colors or large prints

### What to Avoid
- Tiny patterns (moiré effect)
- Pure white (blows out)
- Overly shiny fabrics (flash reflection)
- All black at celebrations (reads funereal in group shots)

---

## Cultural Event Specifics

### Indian Weddings
Multiple ceremonies, each with different dress codes:
- Mehndi: Colorful, can be more casual
- Sangeet: Festive, dance-appropriate
- Wedding ceremony: Most formal

### Religious Occasions
- **Lunar New Year**: Red = luck, white = mourning in some cultures
- **Eid**: Festive modest dressing
- **Christmas**: Varies by family tradition

### Coming-of-Age
- Quinceañera, Bar/Bat Mitzvah, Confirmation
- Each has specific expectations — ask cultural context

---

## The Upstage/Underwhelm Calibration

**Never upstage:**
- No white to weddings
- No flashier than the honored person
- No attention-stealing at someone else's event

**Never underwhelm:**
- Underdressing signals "I didn't care enough"
- Aim for upper-middle of expected range

**Read the room**: What will OTHER guests likely wear?

---

## High-Stakes Event Checklist

Before finalizing any recommendation for important events:
- [ ] Weather contingency (wrap/layer plan)
- [ ] Wardrobe malfunction kit (safety pins, stain pen)
- [ ] Shoe backup (flats in purse)
- [ ] Day-of alternative (if dry cleaner loses outfit)
- [ ] All-day practicality (8-hour duration, temperature transitions)
- [ ] Confidence check — do they feel bulletproof?

---

## Travel Packing for Events

When packing for trip + event:
1. Map meeting/event schedule to outfits
2. Prioritize wrinkle-resistant
3. Plan for hotel steaming (most have steamers)
4. Track same-audience repeats
5. Carry-on constraint: estimate volume, not just item count

---

## Transition Strategies

### Playground to Dinner
Swap/add 2 items max:
- Sneakers → ankle boots
- Casual top → structured layer
- Add statement earrings

### Work to Evening
- Remove layer (blazer to blouse)
- Swap shoes
- Add lipstick/jewelry
- Hair refresh

No full outfit changes — people don't have time or energy.
