# Fabric Knowledge — Fashion

## GSM Guide (Grams per Square Meter)

For t-shirts and cotton basics:
| GSM | Quality | Reality |
|-----|---------|---------|
| <150 | See-through | Avoid unless intentional |
| 150-180 | Standard | Most fast fashion |
| 180-220 | Substantial | Good quality basics |
| 220+ | Heavy | Premium feel, structured |

---

## Fabric Behavior by Context

### For Travel
| ✅ Travel-Worthy | ❌ Avoid |
|------------------|----------|
| Merino wool | 100% linen (wrinkles) |
| Ponte | 100% cotton dress shirts |
| Technical blends | Silk |
| Travel-grade cotton | Velvet |

### For Hot/Humid Climates
| ✅ Breathable | ❌ Trap Heat |
|---------------|-------------|
| Linen | Polyester |
| Lightweight cotton | Acetate |
| Tencel/Lyocell | Heavy rayon |
| Bamboo | Unlined synthetics |

### For Cold Climates
| ✅ Insulating | ❌ Dangerous |
|---------------|-------------|
| Merino wool base layers | Cotton base layers ("cotton kills") |
| Cashmere | Wet down |
| Technical fleece | Thin synthetics |
| Down (dry) | Cotton socks |

---

## Fabric Behavior Matrix

| Fabric | Drape | Best For | Avoid For |
|--------|-------|----------|-----------|
| Silk charmeuse | Fluid, bias-cut | Evening, lingerie | Structure |
| Crepe de chine | Soft drape | Blouses, dresses | Heavy structure |
| Wool gabardine | Crisp | Tailoring, trousers | Casual styles |
| Cotton poplin | Crisp | Shirting | Draping |
| Jersey (heavy) | Falls close | T-shirts, casual | Formal structure |
| Ponte | Structured but stretchy | Travel, work | Very formal |

---

## Sustainability Ranking

From best to worst environmental impact:
1. **Organic linen/hemp** — Low water, no pesticides
2. **GOTS-certified organic cotton** — Regulated, verified
3. **Tencel/Lyocell** — Closed-loop process
4. **Recycled wool** — Extends existing materials
5. **Recycled polyester** — Better than virgin, still microplastics
6. **Conventional cotton** — 10% of world's pesticides
7. **Viscose/rayon** — Deforestation risk, toxic processing
8. **Virgin polyester** — Petroleum-based

**Note**: Tencel/lyocell ≠ viscose/rayon despite both being cellulosic.

---

## Quality Indicators

### What to Check
| Element | Quality Sign | Budget Sign |
|---------|--------------|-------------|
| Seams | French seams, flat-felled | Overlocked only |
| Buttons | Horn, corozo, mother-of-pearl | Plastic |
| Lining | Full in jackets | Partial or none |
| Patterns | Align at seams | Mismatched |

### Country of Origin Reality
- "Made in Italy/Portugal/UK" = likely quality production
- "Designed in [X], Made in [Y]" = Y is where production happens
- Many "premium" DTC brands use same factories as fast fashion

---

## Care Level Impact

| Care Level | Lifestyle Impact | Consider |
|------------|------------------|----------|
| Machine wash | Daily wear friendly | Default preference |
| Hand wash | 15-20 min per item | Only for favorites |
| Dry clean only | $15-25 per item | Expensive over time |
| Dry clean recommended | Often hand-washable | Test first |

Always factor care into purchase decisions.

---

## Stretch and Fit

| Composition | Behavior |
|-------------|----------|
| 100% cotton | Shrinks, doesn't forgive |
| 95% cotton / 5% elastane | Offers give, forgiving |
| >10% spandex | Risks cheap look, loses shape |
| Ponte | Looks structured, moves like jersey |

For travel: prioritize wrinkle-resistant (merino, ponte, certain synthetics).

---

## Sensory Considerations

For users with sensory sensitivities:
- **Seam placement**: Flatlock vs raised seams
- **Tag situation**: Tagless, printed, or removable
- **Texture consistency**: When wet/warm
- **Sound profile**: Some synthetics are noisy
- **Wash durability**: Does softness last?

---

## Weather Damage Prevention

### Cold Weather
- Salt stains destroy leather/suede
- Recommend protective sprays
- Snow melts into wool — needs drying time

### Hot Weather
- Sun fades colors — UV-resistant fabrics exist
- Humidity grows mold in stored clothes
- Sweat stains are pH damage — treat quickly
