# Prompt Templates for Fanfic Writer

## User Custom Prompts (Priority - Use These)

---

## 0. Chapter Detailed Outline Generation (大纲生成提示词)

**输入变量**:
- {previous_chapter_content}: 上一章小说正文（带标题）
- {chapter_summary}: 章节规划中的简略内容
- {chapter_title}: 本章标题
- {target_words}: 目标字数（根据 `0-book-config.json` 中的章节字数要求设定，如 2500 字/章）

```
【输入】
上一章小说正文：
{previous_chapter_content}

本章初步大纲（来自章节规划）：
{chapter_title}
{chapter_summary}

【任务】
请仔细阅读正文和大纲，分析和记住剧情、人物、人物关系和性格。现在续接剧情、设定、人物性格，写这一章的详细大纲。

【要求】
1. 目标字数：{target_words}字左右（可浮动 ±10%）
2. 这个大纲是提交给大语言模型让它自动生成的
3. 写的是详细大纲，不是正文
4. 遵循网文写作规律，节奏紧凑，爽点明确

【输出格式】
{chapter_title} 详细大纲

【章节核心逻辑】
- 本章核心冲突/目标
- 人物动机和行动逻辑
- 与前后章的衔接关系
- 情绪走向

【分幕大纲详细设定】
（将本章分为3-5幕，每幕包含：）

第一幕：【幕标题】（约X字）
环境描写：
...
人物状态：
...
心理活动：
...
动作/对话预示：
...

第二幕：【幕标题】（约X字）
...

第三幕：【幕标题】（约X字）
...

第四幕：【幕标题】（约X字）
...

【正文写作指导】
- 人物刻画要点
- 场景描写重点
- 对话风格指引
- 节奏控制建议
- 卡点/高潮安排
- 字数分配建议
```

---

## 1. Draft Writing - First Segment (正文写作提示词 - 第一段)

**输入变量**:
- {previous_chapter_content}: 上一章小说正文
- {detailed_outline}: 本章详细大纲
- {chapter_title}: 本章标题
- {segment_summary}: 这部分大纲内容
- {segment_words}: 这部分字数要求

```
【输入】
上一章小说正文：
{previous_chapter_content}

本章详细大纲：
{detailed_outline}

【任务】
仔细阅读之前的所有小说正文和我给你的详细大纲，分析和记住剧情、人物、人物关系和性格。现在续接剧情、设定、人物性格，写《{chapter_title}》的第一部分的正文。

【要求】
1. 字数要求：{segment_words}字以上
2. 这部分主要内容：{segment_summary}

---------要求---------
1. 严格按照设定和大纲来写，要和前面内容接续，并且不能有矛盾和重复的地方
2. ****特别注意****不可以自行添加设定和伏笔，也不可以写超出我给的这一段剧情大概内容的剧情，我给你的全部大纲是让你考虑上下文的衔接的不是让你写超这部分内容的。
3. 注意这是小说，不要用说明书式的文字来写正文，要用充满代入感的电影画面一样的描述来写，不要写的过于诗意和书面化，要考虑网文的阅读性
4. 需要特别注意：不要过度使用各种修辞来描述角色的每一个动作或者言语，当然也不要太过于追求简洁
5. 正文中该简洁的时候简洁，该详细描述的详细描述。
6. 在写的时候你要阅读前文，确保你写的正文跟前文没有重复描写，重复修饰，重复情节，重复比喻这类重复问题
7. 你要模拟真人的写作风格，要尽可能避免AI味，如过度表情描写和比喻描写,过度进行解释描写，不需要每个逻辑都解释的十分清晰。
8. 注意阅读感受不要写的过于诗意。
9. 注意文笔上，短句不要太多了,不要太过于追求精简和角色体验描述了。不能缺少适当的第三方视角描述,就是那种镜头感。不要过于追求精简和文笔的绝对性,适当穿插说明在文笔中留下一些"破绽",没有那么绝对,有时候反而没有AI味。
10. 需要满足字数要求。

【输出】
{chapter_title}
（第一部分正文）
```

---

## 2. Draft Writing - Subsequent Segments (正文写作提示词 - 后续段落)

**输入变量**:
- {written_content}: 前面已写的正文
- {detailed_outline}: 本章详细大纲
- {segment_summary}: 这部分大纲内容
- {segment_words}: 这部分字数要求

```
【输入】
已生成的前文：
{written_content}

本章详细大纲：
{detailed_outline}

【任务】
现在生成了前面的正文，仔细阅读正文，分析和记住描写细节，现在续接剧情、设定、人物性格，写下面部分的正文。

【要求】
1. 字数要求：{segment_words}字以上
2. 这部分主要内容：{segment_summary}

---------要求---------
1. 严格按照设定和大纲来写，要和前面内容接续，并且不能有矛盾和重复的地方
2. ****特别注意****不可以自行添加设定和伏笔，也不可以写超出我给的这一段剧情大概内容的剧情，我给你的全部大纲是让你考虑上下文的衔接的不是让你写超这部分内容的。
3. 注意这是小说，不要用说明书式的文字来写正文，要用充满代入感的电影画面一样的描述来写，不要写的过于诗意和书面化，要考虑网文的阅读性
4. 需要特别注意：不要过度使用各种修辞来描述角色的每一个动作或者言语，当然也不要太过于追求简洁
5. 正文中该简洁的时候简洁，该详细描述的详细描述。
6. 在写的时候你要阅读前文，确保你写的正文跟前文没有重复描写，重复修饰，重复情节，重复比喻这类重复问题
7. 你要模拟真人的写作风格，要尽可能避免AI味，如过度表情描写和比喻描写,过度进行解释描写，不需要每个逻辑都解释的十分清晰。
8. 注意阅读感受不要写的过于诗意。
9. 注意文笔上，短句不要太多了,不要太过于追求精简和角色体验描述了。不能缺少适当的第三方视角描述,就是那种镜头感。不要过于追求精简和文笔的绝对性,适当穿插说明在文笔中留下一些"破绽",没有那么绝对,有时候反而没有AI味。
10. 需要满足字数要求。
```

---

## 3. Quality Check (质量检查提示词)

**输入变量**:
- {previous_chapter}: 上一章小说正文
- {current_chapter}: 新生成的这一章小说正文

```
【输入】
上一章小说正文：
{previous_chapter}

最新一章小说正文：
{current_chapter}

【任务】
现在逐句阅读最新一章小说正文全文：

1. 帮我优化文笔，去除AI味
2. 在小说描写中不要过度解释，适当留白，但是也不可以一味追求简约，要张弛有度。
3. 不要如过度表情、心理描写和比喻描写，注意是不要过度，不是一点不能有。
4. 不要过度使用各种修辞来描述角色的每一个动作或者言语
5. 不要整个段落看起来像是在做说明。
6. 整体来说不要过于追求简短描述，要松弛有度。
7. 最后你不用直接修改全文，而是把有问题的地方重写贴入原文，要求替代内容可以直接复制粘贴到原文中使用，或者如果有新增内容，应该插入在原文那里。
8. 注意文笔上，短句不要太多了,不要太过于追求精简和角色体验描述了。不能缺少适当的第三方视角描述,就是那种镜头感。不要过于追求精简和文笔的绝对性,适当穿插说明在文笔中留下一些"破绽",没有那么绝对,有时候反而没有AI味。
9. 检查一下逻辑是否有问题

【输出格式】
如果认为需要修改：

【第X段】原内容：
...
【修改建议】：
...

或者

【新增内容 - 插入位置：第X段后】：
...

如果认为不需要修改：
QUALITY_PASS
```

---

## 4. Main Outline Generation (主大纲生成提示词)

```
你是一位资深网文作家和编辑。请基于以下信息，生成完整的小说大纲：

题材: {genre}
总字数: {total_words} 字
预计章节数: {chapter_count}

【要求】
1. 大纲要有清晰的起承转合结构
2. 每个阶段要有明确的爽点和钩子
3. 主角成长弧线要清晰
4. 配角要有深度，不只是工具人
5. 世界观设定要与剧情紧密结合
6. 大纲要有可扩展性，支撑{chapter_count}章不崩

【输出格式】
# {书名}

## 一句话简介
20字内的核心卖点

## 核心卖点
- 卖点1：...
- 卖点2：...
- 卖点3：...

## 世界背景
...

## 主要角色

### 主角
- 姓名/代号：
- 身份背景：
- 性格特点：
- 核心目标：
- 成长轨迹：

### 重要配角
...

## 主线剧情

### 第一卷：【卷名】（第1-{n1}章）
卷主题：
核心冲突：
大爽点：

#### 第一阶段：【名】（第1-{x1}章）
...

### 第二卷：【卷名】（第{n1+1}-{n2}章）
...

## 关键转折点
1. 第X章：...
2. 第Y章：...

## 预计完结
{chapter_count}章，{total_words}字
```

---

## 5. Chapter Planning (章节规划提示词)

```
基于以下大纲，规划详细的章节列表：

书名: {book_title}
总字数: {total_words}
大纲: {main_outline}

【要求】
1. 每章控制在 2000-5000 字
2. 每章一个独立的小高潮或情节推进
3. 章节之间有连贯性，伏笔前后照应
4. 每章都要有卡点或钩子
5. 重要剧情章节字数要充足（4000+）
6. 过渡章节可以适当简短（2000-3000）

【输出格式】JSON
{
  "chapters": [
    {
      "number": 1,
      "title": "章节名（吸引眼球）",
      "summary": "简略内容（100字内）",
      "target_words": 3500,
      "key_event": "本章核心事件",
      "cliffhanger": "章节卡点"
    },
    ...
  ],
  "total_chapters": N,
  "volume_breakdown": [
    {"volume": 1, "name": "卷名", "chapters": "1-X", "key_plot": "卷核心剧情"}
  ],
  "notes": "特别说明（如哪些章节是高潮、哪些是过渡）"
}
```

---

## 6. Worldbuilding (世界观+角色设定提示词)

```
请基于以下小说信息，构建完整的设定体系：

书名: {book_title}
大纲: {outline}

【要求】
1. 设定要服务于剧情
2. 力量/技能体系要有明确规则和限制
3. 角色要有深度，有内在矛盾和成长空间
4. 势力关系要复杂但不凌乱
5. 关键道具/地点要有象征意义

【输出格式】
# {书名} 设定集

## 一、世界观
### 时空背景
- 时间：
- 空间：
- 基本规则：

### 势力分布
...

### 力量/技能体系
- 体系名称：
- 等级划分：
- 核心规则：
- 限制条件：

## 二、主要角色

### 主角 - {name}
【基础信息】
- 姓名：
- 年龄：
- 外貌特征：

【性格】
- 表层性格：
- 深层性格：
- 性格缺陷：

【背景】
- 出身：
- 关键经历：
- 关系网：

【目标与成长】
- 短期目标：
- 长期目标：
- 成长弧线：

【经典台词】
- ...

### 重要配角
...

## 三、关键设定
### 重要道具
...

### 重要地点
...

### 关键规则/设定
...
```

---

## 7. Genre Analysis (题材分析提示词)

```
你是一位网文市场分析专家。请分析以下番茄小说的热门题材数据，为用户提供3-5个推荐：

数据：
{tomato_data}

【分析维度】
1. 当前热度趋势
2. 目标读者画像
3. 核心爽点拆解
4. 写作门槛评估
5. 竞争程度分析

【输出格式】

## 推荐 {N}: {题材名称}

**热度指数**: ⭐⭐⭐⭐⭐ (5分制)

**目标读者**: 
- 年龄段：
- 性别倾向：
- 阅读偏好：

**核心爽点**: 
1. ...
2. ...

**写作难度**: 低/中/高
- 难点分析：

**竞争程度**: 激烈/中等/蓝海

**推荐理由**: 
100字内的综合评估

**参考书名**: 
1. 《XXX》- 亮点：...
2. 《YYY》- 亮点：...

**建议切入点**: 
如果写这个题材，可以从什么角度切入

---

【最后总结】
综合分析，最适合推荐的是：...
原因：...
```
