---
name: fal-image-gen
description: "Call fal.ai model APIs for image generation (text-to-image and image-to-image). Use when a user asks to integrate fal, construct requests, run jobs, handle auth, or return image URLs from fal model APIs."
---

# Fal Image Gen

## Overview
Use this skill to implement text-to-image or image-to-image calls against fal model APIs. Prioritize correctness by checking the current docs for the selected model’s required inputs/outputs and authentication requirements.

## Quick Start
1. Identify the target model ID from the fal model API docs.
2. Collect inputs from the user.
- Text-to-image: `prompt`, optional `negative_prompt`, size/aspect, steps, seed, safety options.
- Image-to-image: source image URL, strength/denoise, plus prompt/options above.
3. Pick the calling method.
- If the user prefers SDKs: provide Python and/or JavaScript examples.
- If the user prefers REST: provide a curl/HTTP example.
4. Execute the request and return image URL(s) from the response.

## Workflow: Text-to-Image
1. Resolve the model ID and schema.
- Open the fal model API docs and confirm the exact input fields and output format.
2. Validate inputs.
- Ensure prompt is non-empty and size/aspect settings are supported by the model.
3. Build the request.
- SDK: call the SDK’s `run`/`submit` method with an `input` object.
- REST: call the model endpoint with a JSON body that matches the schema.
4. Execute and parse output.
- Extract image URL(s) from the response fields defined by the model.
5. Return URLs.
- Provide a clean list of URLs and note any metadata the user asked for (seed, size, etc.).

## Workflow: Image-to-Image
1. Resolve the model ID and schema.
2. Validate inputs.
- Ensure the source image is reachable by URL (or converted to the required format).
- Confirm any strength/denoise range constraints from docs.
3. Build the request.
- Include source image + prompt + other options as required by the model.
4. Execute and parse output.
- Extract image URL(s) from the response fields defined by the model.
5. Return URLs.

## SDK vs REST Guidance
- Prefer SDKs for simpler auth and retries.
- Prefer REST when the user needs raw HTTP examples, or when running in environments without SDK support.
- Never hardcode API keys. Follow the docs for the required environment variable or header name.

## Minimal Examples (Fill From Docs)
Use these as templates only. Replace placeholders after checking the docs.

### Python (SDK)
```python
# Pseudocode: replace with the exact fal SDK import + call pattern from docs
import os
# from fal import client  # or the current SDK import

MODEL_ID = "<model-id-from-docs>"
input_data = {
    "prompt": "a cinematic photo of a red fox",
    # "image_url": "https://..."  # for image-to-image
    # "negative_prompt": "...",
    # "width": 1024,
    # "height": 1024,
}

# result = client.run(MODEL_ID, input=input_data)
# urls = extract_urls(result)
```

### JavaScript (SDK)
```javascript
// Pseudocode: replace with the exact fal SDK import + call pattern from docs
// import { client } from "@fal-ai/client";

const MODEL_ID = "<model-id-from-docs>";
const input = {
  prompt: "a cinematic photo of a red fox",
  // image_url: "https://..." // for image-to-image
};

// const result = await client.run(MODEL_ID, { input });
// const urls = extractUrls(result);
```

### REST (curl)
```bash
# Pseudocode: replace endpoint, headers, and payload schema from docs
curl -X POST "https://<fal-api-base>/<model-endpoint>" \
  -H "Authorization: Bearer <API_KEY>" \
  -H "Content-Type: application/json" \
  -d '{
    "prompt": "a cinematic photo of a red fox"
  }'
```

## Resources
- `references/fal-model-api-checklist.md`: Checklist for gathering inputs and validating responses.
- `references/fal-model-examples.md`: Example templates for text-to-image, image-to-image, and REST usage.
