# Popular fal.ai Models Quick Reference

## Text-to-Image

| Model ID | Name | Notes |
|----------|------|-------|
| `fal-ai/flux/dev` | FLUX.1 [dev] | High quality, good default |
| `fal-ai/flux/schnell` | FLUX.1 [schnell] | Fast, 1-4 steps |
| `fal-ai/flux-pro/v1.1-ultra` | FLUX Pro Ultra | Best quality, up to 2K |
| `fal-ai/flux-lora` | FLUX LoRA | Custom fine-tuned styles |
| `fal-ai/stable-diffusion-v3-medium` | SD3 Medium | Stable Diffusion 3 |
| `fal-ai/fast-sdxl` | Fast SDXL | Quick SDXL generation |
| `fal-ai/sana` | Sana | Efficient text-to-image |

## Image-to-Video

| Model ID | Name | Notes |
|----------|------|-------|
| `fal-ai/kling-video/v2/image-to-video` | Kling v2 | High quality, motion control |
| `fal-ai/minimax/video-01/image-to-video` | Minimax | Good motion |
| `fal-ai/wan/v2.1/image-to-video` | Wan 2.1 | Open source |
| `fal-ai/luma-dream-machine/image-to-video` | Luma | Cinematic quality |
| `fal-ai/ltx-video/image-to-video` | LTX Video | Fast generation |

## Text-to-Video

| Model ID | Name | Notes |
|----------|------|-------|
| `fal-ai/kling-video/v2/text-to-video` | Kling v2 | Text prompts to video |
| `fal-ai/minimax/video-01` | Minimax | Text to video |
| `fal-ai/wan/v2.1/text-to-video` | Wan 2.1 | Open source |
| `fal-ai/cogvideox-5b` | CogVideoX | 5B param model |

## Audio/Speech

| Model ID | Name | Notes |
|----------|------|-------|
| `fal-ai/whisper` | Whisper | Speech to text |
| `fal-ai/elevenlabs/tts` | ElevenLabs TTS | Text to speech |
| `fal-ai/f5-tts` | F5 TTS | Open source TTS |
| `fal-ai/kokoro` | Kokoro | Fast TTS |

## Image Editing

| Model ID | Name | Notes |
|----------|------|-------|
| `fal-ai/flux/dev/image-to-image` | FLUX img2img | Image transformation |
| `fal-ai/flux-pro/v1/fill` | FLUX Inpainting | Fill/edit regions |
| `fal-ai/flux-pro/v1/canny` | FLUX ControlNet | Edge-guided generation |
| `fal-ai/birefnet` | BiRefNet | Background removal |
| `fal-ai/face-swap` | Face Swap | Swap faces in images |

## 3D Generation

| Model ID | Name | Notes |
|----------|------|-------|
| `fal-ai/hunyuan3d/v2` | Hunyuan3D v2 | Image/text to 3D |
| `fal-ai/trellis` | Trellis | 3D generation |

## Training/Fine-tuning

| Model ID | Name | Notes |
|----------|------|-------|
| `fal-ai/flux-lora-fast-training` | FLUX LoRA Training | Train custom styles |
| `fal-ai/flux-lora-portrait-trainer` | Portrait Trainer | Face fine-tuning |

---

## Common Input Parameters

### Text-to-Image (FLUX)
```json
{
  "prompt": "your prompt here",
  "image_size": "landscape_16_9",  // or "square", "portrait_4_3", etc.
  "num_images": 1,
  "seed": 12345,  // optional, for reproducibility
  "guidance_scale": 3.5,
  "num_inference_steps": 28
}
```

### Image-to-Video
```json
{
  "image_url": "https://...",
  "prompt": "motion description",
  "duration": 5,  // seconds
  "aspect_ratio": "16:9"
}
```

### Speech-to-Text (Whisper)
```json
{
  "audio_url": "https://...",
  "task": "transcribe",  // or "translate"
  "language": "en"
}
```
