# fal-skill

A [Claude Code](https://claude.ai/code) skill for running [fal.ai](https://fal.ai) generative AI models - image generation, video, audio, 3D, and more.

## Installation

```bash
git clone https://github.com/fal-ai/fal-skill ~/.claude/skills/fal
```

## Setup

1. Get an API key from [fal.ai/dashboard/keys](https://fal.ai/dashboard/keys)

2. Add to your shell config (`~/.zshrc` or `~/.bashrc`):
   ```bash
   export FAL_KEY="your-key-here"
   ```

3. Reload your shell:
   ```bash
   source ~/.zshrc
   ```

## Usage

### Commands

| Command | Description |
|---------|-------------|
| `/fal search <query>` | Search 600+ models |
| `/fal schema <model_id>` | Get input/output schema |
| `/fal run <model_id> --param value` | Run a model |
| `/fal status <model_id> <request_id>` | Check job status |
| `/fal result <model_id> <request_id>` | Get job result |
| `/fal upload <file>` | Upload file to fal CDN |

### Examples

```bash
# Search for models
/fal search video

# See what inputs a model accepts
/fal schema fal-ai/flux-2

# Generate an image
/fal run fal-ai/flux-2 --prompt "a cat in space"
```

Or just ask Claude naturally:

> "Generate an image of a sunset over mountains"

> "Turn this photo into a video"

> "What image models are available?"

## Popular Models

| Model | Category |
|-------|----------|
| `fal-ai/flux-2` | Text to image |
| `fal-ai/flux-2-pro` | Text to image (high quality) |
| `fal-ai/kling-video/v2/image-to-video` | Image to video |
| `fal-ai/minimax/video-01/image-to-video` | Image to video |
| `fal-ai/whisper` | Speech to text |

See [models-reference.md](models-reference.md) for a full list.

## How It Works

This skill teaches Claude how to interact with fal.ai APIs using curl. When you ask Claude to generate media, it:

1. Searches for appropriate models (if needed)
2. Fetches the model schema to understand required inputs
3. Submits the job to fal's queue
4. Polls for completion
5. Downloads results to your machine

## Links

- [fal.ai Models](https://fal.ai/models) - Browse all available models
- [fal.ai Docs](https://docs.fal.ai) - API documentation
- [Claude Code Skills](https://docs.anthropic.com/en/docs/claude-code/skills) - Learn about skills

## License

MIT
