---
name: ez-unifi
description: Use when asked to manage UniFi network - list/restart/upgrade devices, block/unblock clients, manage WiFi networks, control PoE ports, manage traffic rules, create guest vouchers, or any UniFi controller task. Works with UDM Pro/SE, Dream Machine, Cloud Key Gen2+, or self-hosted controllers.
metadata: {"openclaw":{"emoji":"📶"}}
---

# ez-unifi

Agent-friendly UniFi Network tools powered by the `aiounifi` library. Supports UDM Pro/SE, Dream Machine, Cloud Key Gen2+, and self-hosted controllers.

**Run all commands with:** `uv run scripts/unifi.py <command> [args]`

## Setup

**Step 1: Ask user to create a dedicated local admin account**

> To manage your UniFi network, I need API access. Please create a dedicated local admin account:
>
> 1. Open your UniFi controller (e.g., https://192.168.1.1)
> 2. Go to **Settings → System → Admins & Users**
> 3. Click **Add Admin**
> 4. Enter a username (e.g., `agent-api`)
> 5. Enter an email and password
> 6. **Important: Disable "Remote Access"** - local-only avoids MFA issues
> 7. Set Role to **Super Admin** or **Site Admin**
> 8. Click **Add**
>
> Then provide:
> - Controller IP (e.g., `192.168.1.1`)
> - Username
> - Password
> - Is it a UDM Pro/SE/Dream Machine? (yes/no)

**Step 2: Save credentials to `.env`**

```bash
UNIFI_HOST=https://192.168.1.1
UNIFI_USERNAME=agent-api
UNIFI_PASSWORD=the_password
UNIFI_SITE=default
UNIFI_IS_UDM=true
```

Set `UNIFI_IS_UDM=false` for Cloud Key Gen1 or self-hosted controllers.

---

## System & Sites

```bash
unifi.py sites                     # List all sites
unifi.py sysinfo                   # System information
unifi.py health                    # Site health status (WAN, WLAN, LAN)
```

## Devices (APs, Switches, Gateways)

```bash
unifi.py devices                   # List all devices
unifi.py device MAC                # Device details
unifi.py restart MAC               # Restart device
unifi.py restart MAC --hard        # Hard restart (cycles PoE on switches)
unifi.py upgrade MAC               # Upgrade device firmware
unifi.py locate MAC                # Blink LED to locate
unifi.py unlocate MAC              # Stop LED blinking
unifi.py led MAC on|off|default    # Set LED status
unifi.py led MAC on --color=#FF0000 --brightness=50  # With color/brightness
```

## Switch Ports

```bash
unifi.py ports                     # List all switch ports
unifi.py port MAC PORT_IDX         # Port details
unifi.py port-enable MAC PORT_IDX  # Enable switch port
unifi.py port-disable MAC PORT_IDX # Disable switch port
unifi.py poe MAC PORT_IDX MODE     # Set PoE mode (auto|off|passthrough|24v)
unifi.py power-cycle MAC PORT_IDX  # Power cycle a PoE port
```

## Smart Power (PDU/Outlets)

```bash
unifi.py outlets                   # List all outlets
unifi.py outlet MAC IDX on|off     # Control outlet relay
unifi.py outlet-cycle MAC IDX on|off  # Enable/disable auto-cycle on internet down
```

## Clients

```bash
unifi.py clients                   # List active clients
unifi.py clients-all               # List all clients (including offline/known)
unifi.py client MAC                # Client details
unifi.py block MAC                 # Block client from network
unifi.py unblock MAC               # Unblock client
unifi.py reconnect MAC             # Kick/reconnect client
unifi.py forget MAC [MAC2...]      # Forget client(s) permanently
```

## WiFi Networks

```bash
unifi.py wlans                     # List wireless networks
unifi.py wlan ID                   # WLAN details
unifi.py wlan-enable ID            # Enable WLAN
unifi.py wlan-disable ID           # Disable WLAN
unifi.py wlan-password ID NEWPASS  # Change WLAN password
unifi.py wlan-qr ID                # Generate WiFi QR code (PNG file)
unifi.py wlan-qr ID -o myqr.png    # Custom output filename
```

## Port Forwarding

```bash
unifi.py port-forwards             # List port forwarding rules
unifi.py port-forward ID           # Port forward details
```

## Traffic Rules

```bash
unifi.py traffic-rules             # List traffic rules
unifi.py traffic-rule ID           # Traffic rule details
unifi.py traffic-rule-enable ID    # Enable traffic rule
unifi.py traffic-rule-disable ID   # Disable traffic rule
unifi.py traffic-rule-toggle ID on|off  # Toggle traffic rule state
```

## Traffic Routes

```bash
unifi.py traffic-routes            # List traffic routes
unifi.py traffic-route ID          # Traffic route details
unifi.py traffic-route-enable ID   # Enable traffic route
unifi.py traffic-route-disable ID  # Disable traffic route
```

## Firewall

```bash
unifi.py firewall-policies         # List firewall policies
unifi.py firewall-policy ID        # Firewall policy details
unifi.py firewall-zones            # List firewall zones
unifi.py firewall-zone ID          # Firewall zone details
```

## DPI (Deep Packet Inspection)

```bash
unifi.py dpi-apps                  # List DPI restriction apps
unifi.py dpi-app ID                # DPI app details
unifi.py dpi-app-enable ID         # Enable DPI app restriction
unifi.py dpi-app-disable ID        # Disable DPI app restriction
unifi.py dpi-groups                # List DPI restriction groups
unifi.py dpi-group ID              # DPI group details
```

## Hotspot Vouchers

```bash
unifi.py vouchers                  # List vouchers
unifi.py voucher-create --duration=60 --quota=1 --note="Guest"
unifi.py voucher-create --duration=1440 --quota=5 --rate-up=5000 --rate-down=10000
unifi.py voucher-delete ID         # Delete voucher
```

Voucher options:
- `--duration` - Duration in minutes (default: 60)
- `--quota` - Number of uses (default: 1)
- `--usage-quota` - Usage quota in MB
- `--rate-up` - Upload rate limit in Kbps
- `--rate-down` - Download rate limit in Kbps
- `--note` - Note/description

## Events

```bash
unifi.py events                    # Stream events in real-time (Ctrl+C to stop)
```

## Raw API Access

```bash
unifi.py raw GET /stat/health      # Raw GET request
unifi.py raw POST /cmd/devmgr '{"cmd":"restart","mac":"aa:bb:cc:dd:ee:ff"}'
unifi.py raw PUT /rest/wlanconf/ID '{"enabled":false}'
```

## Output Options

Add `--json` flag to any list command for JSON output:
```bash
unifi.py devices --json            # JSON output
unifi.py clients --json
```

---

## Examples

```bash
# Check network health
uv run scripts/unifi.py health

# List all connected clients
uv run scripts/unifi.py clients

# Block a device
uv run scripts/unifi.py block "aa:bb:cc:dd:ee:ff"

# Restart an access point
uv run scripts/unifi.py restart "11:22:33:44:55:66"

# Disable guest WiFi
uv run scripts/unifi.py wlan-disable "5f8b3d2e1a4c7b9e0d6f8a2c"

# Upgrade device firmware
uv run scripts/unifi.py upgrade "11:22:33:44:55:66"

# Power cycle a PoE port (useful for rebooting PoE devices)
uv run scripts/unifi.py power-cycle "switch_mac" 5

# Create a guest voucher (24 hours, single use)
uv run scripts/unifi.py voucher-create --duration=1440 --quota=1 --note="Guest access"

# Generate WiFi QR code for easy connection
uv run scripts/unifi.py wlan-qr "wlan_id" -o guest_wifi.png

# Control traffic rule
uv run scripts/unifi.py traffic-rule-disable "rule_id"
```

## Finding IDs

- **WLAN IDs**: Run `wlans` and look for the `ID` column
- **Device MACs**: Run `devices` and look for the `MAC` column
- **Client MACs**: Run `clients` or `clients-all` and look for the `MAC` column
- **Traffic Rule IDs**: Run `traffic-rules` and look for the `ID` column
- **Voucher IDs**: Run `vouchers` and look for the `ID` column

## Notes

- MAC addresses can be any format (with colons, dashes, or none)
- All output is JSON for easy parsing
- Using a dedicated local account avoids MFA issues with cloud-linked accounts
- If you get rate limited (429 error), wait a few minutes before retrying
