# Expo Native UI

Build beautiful native iOS/Android apps with Expo Router. Covers route structure, native tabs, animations, blur effects, liquid glass, SF Symbols, and platform patterns.

## What's Inside

- File-based routing with native navigation stacks
- Native tab bars (NativeTabs) and iOS 26 features
- SF Symbols integration via expo-symbols
- Blur effects (expo-blur) and liquid glass (expo-glass-effect)
- Reanimated animations and gesture handling
- Native controls: Switch, Slider, SegmentedControl, DateTimePicker
- Link previews and context menus
- Form sheet modals
- Camera, audio, video, and file storage
- WebGPU and Three.js for 3D graphics

## When to Use

- Building a new Expo Router app
- Adding native tab navigation
- Implementing iOS-style blur or liquid glass effects
- Creating smooth animations with entering/exiting transitions
- Integrating SF Symbols for icons
- Setting up route structure with groups and dynamic routes

## Installation

```bash
npx add https://github.com/wpank/ai/tree/main/skills/frontend/expo-native-ui
```

### OpenClaw / Moltbot / Clawbot

```bash
npx clawhub@latest install expo-native-ui
```

### Manual Installation

#### Cursor (per-project)

From your project root:

```bash
mkdir -p .cursor/skills
cp -r ~/.ai-skills/skills/frontend/expo-native-ui .cursor/skills/expo-native-ui
```

#### Cursor (global)

```bash
mkdir -p ~/.cursor/skills
cp -r ~/.ai-skills/skills/frontend/expo-native-ui ~/.cursor/skills/expo-native-ui
```

#### Claude Code (per-project)

From your project root:

```bash
mkdir -p .claude/skills
cp -r ~/.ai-skills/skills/frontend/expo-native-ui .claude/skills/expo-native-ui
```

#### Claude Code (global)

```bash
mkdir -p ~/.claude/skills
cp -r ~/.ai-skills/skills/frontend/expo-native-ui ~/.claude/skills/expo-native-ui
```

## Related Skills

- `native-ui` — Similar patterns with additional form sheet and toolbar references

---

Part of the [Frontend](..) skill category.
