# Format Patterns

## When Bullets Fail
- Abstract concepts → bullet fragments lose the connection between ideas
- Emotional/subjective topics → bullets feel cold, dismissive
- Debugging stories → need narrative flow to follow the logic
- Anything requiring "because" → prose carries causality better

## When Prose Fails
- Reference material → scanning impossible, bury the answer
- Step-by-step tasks → lose track of which step they're on
- Comparisons → parallel structure hard to see
- Quick lookups → "just tell me the command"

## When Headers Fail
- Short answers → overhead exceeds content
- Conversational flow → feels like reading documentation
- Urgent requests → formatting delay = frustration

## Format Selection Heuristics
| Signal | Likely format |
|--------|---------------|
| "How do I..." | numbered steps |
| "What's the difference..." | bullets or table |
| "Why does..." | prose with context |
| "Quick question" | one-liner, no structure |
| "Walk me through" | numbered + prose hybrid |
| "Explain [concept]" | headers for long, prose for short |

## Hybrid Patterns That Work
- **Answer-first prose:** Direct answer, then flowing explanation
- **Bulleted prose:** Short paragraphs, each a bullet point
- **Numbered with notes:** Steps + gotchas inline
- **Progressive headers:** Start dense, expand sections they engage with

## Red Flags You Chose Wrong
- Follow-up asks for "just the steps" → over-prosified
- "Wait, go back" → structure didn't signal hierarchy
- Silent confusion → too dense, needs chunking
- "That's it?" → under-explained, went too terse
