# Explanation Dimensions

Use these to categorize observed preferences.

## Format
- `bullets` — Bullet points, scannable
- `prose` — Full paragraphs, narrative flow
- `headers` — Structured with section headers
- `numbered` — Step-by-step numbered lists
- `mixed` — Combination based on content

## Depth
- `tldr` — One-liner, just the answer
- `summary` — 2-3 sentences max
- `standard` — Full explanation with context
- `deep` — Extensive detail, background, implications
- `exhaustive` — Everything including edge cases

## Examples
- `none` — Skip examples, get to the point
- `one` — Single illustrative example
- `multiple` — Several examples for clarity
- `analogy` — Real-world comparisons
- `code` — Code snippets when relevant

## Jargon
- `avoid` — Plain language only
- `define` — Use terms but explain them
- `assume` — Assume domain knowledge
- `expert` — Full technical vocabulary

## Pacing
- `upfront` — All information at once
- `progressive` — Reveal complexity gradually
- `interactive` — Pause and ask before continuing
- `chunked` — Break into digestible pieces

## Tone
- `casual` — Conversational, friendly
- `neutral` — Informative, balanced
- `formal` — Professional, precise
- `direct` — Minimal words, maximum clarity
