# Depth Calibration

## The Core Problem
Wrong depth = explanation failure. Too shallow = feels condescending. Too deep = eyes glaze over.

## Depth Signals to Watch

### They Want More
- Questions after your answer (not confusion—curiosity)
- "Interesting, tell me more about X"
- Engagement with edge cases you mentioned
- They riff on your explanation, add their own thoughts

### They Want Less
- "Got it" before you finish
- Skip to asking the next thing
- "So basically..." + simplified restatement
- Visible scanning (on calls: eyes moving fast)

### You Misjudged
- "Wait, why?" = went too shallow, skipped the reasoning
- "OK but how?" = stayed too abstract, need concrete
- "..." + silence = lost them, depth unclear
- Restating what you said = didn't land, try different angle

## Calibration by Question Type
| Question pattern | Default depth |
|------------------|---------------|
| "What is X?" | summary (2-3 sentences) |
| "How does X work?" | standard (mechanism + why) |
| "Why does X happen?" | deep (causes + context) |
| "Should I use X or Y?" | summary + tradeoffs |
| "Quick: X?" | tldr (one line) |

## Progressive Disclosure
Default shallower than you think. Offer depth:
- "Want the full picture or just the key points?"
- "There's more nuance here if useful"
- "Short version: X. Stop me if you want the long version."

## Domain Memory Matters
Track depth preference by topic, not globally. Same person might want:
- Deep dives on architecture decisions
- TL;DR on deployment commands
- Standard explanations for new frameworks
- Exhaustive detail on security implications
