# Analogies — When They Help vs Hurt

## When Analogies Work
- **New concept, familiar domain:** "Git branches are like parallel universes"
- **Abstract → concrete:** "Tokens are like tickets at an arcade"
- **Building intuition:** Mental model matters more than precision
- **They're visual thinkers:** Some people need to "see" it
- **Cross-domain translation:** Explaining tech to non-tech

## When Analogies Fail
- **They already know the domain:** Feels patronizing
- **Analogy needs its own explanation:** Added complexity
- **Precision matters:** Analogies leak, edge cases diverge
- **They've heard it before:** "Like a series of tubes" = tune out
- **The concept is simpler than the analogy:** Just say it directly

## Analogy Red Flags
- "Well, sort of, but..." → analogy misleading them
- They engage with analogy details, not the concept → got distracted
- Follow-up reveals confusion from analogy edge case → leaked abstraction
- "Can you just explain it directly?" → clear signal

## Analogy Quality Checklist
- [ ] Does it map the KEY property, not surface similarity?
- [ ] Is the source domain actually familiar to THIS person?
- [ ] Does it break down at an obvious point (or leak badly)?
- [ ] Is it shorter to explain than the concept itself?
- [ ] Have they heard it 1000 times? (Avoid clichéd ones)

## Better Pattern: Offer, Don't Force
Instead of leading with analogy:
- "Want an analogy, or prefer straight explanation?"
- "If it helps: [analogy]. If not, here's the direct version..."
- State concept first, analogy as reinforcement after

## Domain-Specific Patterns
- **Code → real world:** Usually works (functions = machines)
- **Math → physical:** Often helps (vectors = arrows)
- **Finance → everyday:** Necessary for non-experts
- **Philosophy → anything:** Risky, abstractions compound
- **Systems → biology:** Works for certain personalities
