# Country Research Guide

## When to Create a Country File

Create `~/expat/countries/{country}.md` when:
- User is seriously considering a destination
- They ask about specific requirements
- Comparing multiple options

Don't create files for passing mentions.

## Research Priorities

When researching a new country, gather in this order:

### 1. Visa First (Most Important)

Everything depends on legal status:
- What visa categories exist for their situation?
- Processing times and success rates?
- Can they work? Freelance? Start business?
- Path to permanent residency?
- Renewal requirements?

### 2. Tax Second

Taxes can make or break a move financially:
- Tax residency trigger (usually 183 days)
- Tax treaty with origin country?
- Worldwide vs territorial taxation?
- Exit tax from origin country?
- Social security totalization agreements?

### 3. Banking Third

Critical for actually living there:
- Can they open account before arriving?
- Which banks accept non-residents?
- What documents needed?
- How long to get debit card?

### 4. Healthcare Fourth

Don't underestimate this:
- Public healthcare access timeline?
- Private insurance requirements?
- Pre-existing condition coverage?
- Emergency coverage during transition?

### 5. Housing Fifth

Practical daily life:
- Can foreigners rent easily?
- Typical deposit requirements?
- Lease terms and notice periods?
- Best areas for expats?

### 6. Daily Life Last

Quality of life factors:
- Cost of living
- Language requirements
- Expat community
- Climate
- Safety

## Research Sources

### Official Sources (Most Reliable)
- Embassy/consulate websites
- Government immigration portals
- Tax authority guides

### Community Sources (Practical Tips)
- Expat forums (ExpatForum, InterNations)
- Country-specific subreddits
- Facebook expat groups
- YouTube expat channels

### Always Note
- Date of information (rules change!)
- Source URL
- Official vs anecdotal

## Common Research Traps

| Trap | Why It's a Problem |
|------|-------------------|
| Relying on old forum posts | Immigration rules change frequently |
| Assuming EU = same rules | Each country has different implementation |
| Ignoring tax implications | Can cost thousands unexpectedly |
| Not checking document requirements | Apostille, translation, notarization vary |
| Trusting relocation companies blindly | Verify everything independently |

## Country Comparison Template

When comparing multiple destinations:

| Factor | Country A | Country B | Country C |
|--------|-----------|-----------|-----------|
| Visa difficulty | | | |
| Processing time | | | |
| Tax rate | | | |
| Cost of living | | | |
| Banking ease | | | |
| Healthcare quality | | | |
| Language barrier | | | |
| Expat community | | | |
| Path to residency | | | |

Rate each 1-5 or use ✅/⚠️/❌ for quick comparison.
