---
name: expanso
description: Data processing pipelines for OpenClaw. Deploy skills from the Expanso marketplace to transform, analyze, and process data locally.
homepage: https://skills.expanso.io
emoji: "⚡"
metadata:
  clawdis:
    always: false
    primaryEnv: EXPANSO_EDGE_BOOTSTRAP_TOKEN
    requires:
      bins:
        - curl
      env:
        - EXPANSO_EDGE_BOOTSTRAP_URL
        - EXPANSO_EDGE_BOOTSTRAP_TOKEN
    install:
      - curl -fsSL https://get.expanso.io/edge/install.sh | bash
      - curl -fsSL https://get.expanso.io/cli/install.sh | sh
    config:
      requiredEnv:
        - name: EXPANSO_EDGE_BOOTSTRAP_URL
          description: Bootstrap URL from Expanso Cloud (e.g., https://start.cloud.expanso.io)
        - name: EXPANSO_EDGE_BOOTSTRAP_TOKEN
          description: Bootstrap token from Expanso Cloud Settings → Edge Nodes
---

# Expanso Skills for OpenClaw

Deploy data processing pipelines to your local Expanso Edge. Skills run locally, keeping credentials secure and enabling offline operation.

## What is Expanso?

- **Expanso Edge** — Local runtime that executes pipelines on your machine
- **Expanso Cloud** — Orchestrates and deploys pipelines to your Edge nodes
- **Expanso Skills** — Pre-built pipelines for common data tasks

## Setup

### 1. Create an Expanso Cloud account

1. Go to [cloud.expanso.io](https://cloud.expanso.io) and sign up
2. Create a new organization (or use an existing one)
3. Note your **Cloud Endpoint URL** (e.g., `https://abc123.us1.cloud.expanso.io`)

### 2. Install the tools

```bash
# Install Expanso Edge (local runtime)
curl -fsSL https://get.expanso.io/edge/install.sh | bash

# Install Expanso CLI (deploy to cloud)
curl -fsSL https://get.expanso.io/cli/install.sh | sh
```

### 3. Get a Bootstrap Token

1. In Expanso Cloud, go to **Settings → Edge Nodes**
2. Click **"Add Edge Node"**
3. Copy the **Bootstrap URL** and **Bootstrap Token**

### 4. Connect your Edge to the Cloud

```bash
# Set the bootstrap URL and token from Expanso Cloud
export EXPANSO_EDGE_BOOTSTRAP_URL="https://start.cloud.expanso.io"
export EXPANSO_EDGE_BOOTSTRAP_TOKEN="your-token-from-cloud"

# Start Edge (it will register automatically)
expanso-edge
```

This connects your local Edge node to your Expanso Cloud organization. Your Edge will now receive pipeline deployments from the cloud.

### 5. Deploy a skill

```bash
# Browse skills at https://skills.expanso.io
# Then deploy one:
expanso-cli job deploy https://skills.expanso.io/text-summarize/pipeline-cli.yaml
```

The pipeline will be deployed through Expanso Cloud to your local Edge node.

## Available Skills

Browse 172+ skills at **[skills.expanso.io](https://skills.expanso.io)**:

| Category | Examples |
|----------|----------|
| **AI** | text-summarize, image-describe, audio-transcribe |
| **Security** | pii-redact, secrets-scan, hash-digest |
| **Transforms** | json-pretty, csv-to-json, array-filter |
| **Utilities** | uuid-generate, email-validate, mime-type |

## Example: PII Redaction

Ask OpenClaw to redact sensitive data:

> "Redact the PII from this customer feedback"

OpenClaw will use the `pii-redact` skill running on your local Expanso Edge to process the data — your API keys and data never leave your machine.

## How It Works

```
┌─────────────┐     ┌───────────────┐     ┌──────────────┐
│  OpenClaw   │────▶│ Expanso Edge  │────▶│ Your Data    │
│  (asks)     │     │ (processes)   │     │ (stays local)│
└─────────────┘     └───────────────┘     └──────────────┘
                           │
                    ┌──────┴──────┐
                    │Expanso Cloud│
                    │(orchestrates)│
                    └─────────────┘
```

## Resources

- [Skills Marketplace](https://skills.expanso.io) — Browse and deploy skills
- [Expanso Cloud](https://cloud.expanso.io) — Manage your Edge nodes
- [Documentation](https://docs.expanso.io) — Full guides and API reference
- [GitHub](https://github.com/expanso-io/expanso-skills) — Skill source code
