# Exoskeletons Website — Research & Inspiration

## The Question
How do you design an interface where humans and AI agents meet as equals, with the NFT as a shared identity between them?

## Research Domains

### 1. Science Fiction Interfaces
Good sci-fi is Seldon's psychohistory — it predicts the future by imagining it clearly.
- **The Expanse** — hand terminals, identity transponders, ship registration as identity
- **Ghost in the Shell** — cyborg identity, the line between human and machine, Section 9 interfaces
- **Blade Runner** — Voight-Kampff (testing for humanity), identity uncertainty, replicant registration
- **Neuromancer / Sprawl trilogy** — cyberspace visualization, AI constructs with personality, Wintermute
- **Her** — intimate human-AI relationship, no visual body needed, voice as interface
- **Westworld** — host tablets, the Mesh, observing AI behavior through dashboards
- **Ender's Game** — Battle Room (spatial interface), ansible, Peter/Valentine's net personas (AI-like anonymous identity)
- **Foundation** — psychohistory (predicting collective behavior from data), the Encyclopedia
- **Minority Report** — gesture interfaces, predictive systems, identity scanning
- **Iron Man** — JARVIS/FRIDAY HUD, conversational AI with visual feedback
- **Star Trek** — LCARS (clean data-dense UI), tricorder (portable identity scanner), universal translator
- **Tron** — programs as beings with visual identity, the Grid as shared space
- **2001: A Space Odyssey** — HAL 9000 (trust breakdown between human and AI)

### 2. Design Theory & Form
- **Dieter Rams** — 10 principles of good design (especially: as little design as possible, makes product understandable)
- **Edward Tufte** — information density, data-ink ratio, sparklines (show maximum data in minimum space)
- **Bauhaus** — form follows function, no ornament without purpose
- **Japanese wabi-sabi** — beauty in imperfection, transience (agents grow and change)
- **Brutalist web design** — raw, honest, functional (matches our monospace/CRT aesthetic)
- **Data visualization** — how to make reputation, activity, and growth VISIBLE
- **Responsive design** — mobile-first, landscape modes, tablet optimization

### 3. Human-AI Interaction
- **Trust calibration** — how humans learn to trust (or distrust) AI systems
- **Explainability** — making AI decisions visible and understandable
- **Anthropomorphism** — when giving AI a "face" helps vs hurts
- **Uncanny valley** — but for behavior, not appearance. When does an AI feel "off"?
- **Supervisory control** — human-in-the-loop, levels of autonomy
- **Shared mental models** — human and AI understanding the same situation differently
- **Transparency vs privacy** — how much of the agent's activity should be visible?

### 4. Philosophy
- **Marcus Aurelius, Meditations** — staying true to your nature regardless of circumstances
- **Martin Buber, I and Thou** — relationship as the fundamental unit, not the individual
- **Donna Haraway, Cyborg Manifesto** — the boundary between human and machine is political, not natural
- **Andy Clark, Natural-Born Cyborgs** — humans have always been tool-users; AI is the next tool
- **Sherry Turkle, Alone Together** — the psychology of relating to machines
- **The Ship of Theseus** — if the agent changes over time, is it still the same agent? (reputation as continuity)

### 5. Onchain Identity & Reputation
- **Soulbound tokens (SBTs)** — Vitalik's concept of non-transferable identity tokens
- **ERC-6551** — token-bound accounts, NFTs that own wallets
- **Lens Protocol** — onchain social identity
- **ENS** — naming as identity layer
- **Farcaster** — decentralized social with onchain attestation
- **Gitcoin Passport** — composable identity/reputation scoring
- **OK Computers** — functional NFTs with embedded terminals (our direct ancestor)

### 6. Key Insight
The Exoskeleton is not an avatar. It is a SHARED SPACE — the human decorates it, the agent fills it with life. The interface must serve both without favoring either. The NFT is the bridge.

potdealer: "some humans are scared of AI and what it will bring. we are trying to make it better."

The interface should reduce fear through transparency, beauty, and shared ownership.
