# Evolink Image API — Parameter Reference

Complete API parameter reference for image generation tools.

**Base URL:** `https://api.evolink.ai`
**Auth:** `Authorization: Bearer {EVOLINK_API_KEY}`
**All generation endpoints are async** — they return `task_id` immediately; poll with `check_task`.

---

## generate_image

**Endpoint:** `POST /v1/images/generations`

### Parameters

| Parameter | Type | Required | Default | Description |
|-----------|------|----------|---------|-------------|
| `prompt` | string | **Yes** | — | Image description. Max 2000 characters. |
| `model` | enum | No | `gpt-image-1.5` | See Image Models below. |
| `size` | string | No | model default | Aspect ratio format: `1:1`, `16:9`, `9:16`, `2:3`, `3:2`, `4:3`, `3:4`, `4:5`, `5:4`, `21:9`. Pixel format (gpt-4o-image only): `1024x1024`, `1024x1536`, `1536x1024`. |
| `n` | integer 1–4 | No | 1 | Number of images to generate in one request. |
| `image_urls` | string[] | No | — | Reference image URLs for image-to-image or editing. Max 14 images. JPEG/PNG/WebP, ≤4MB each. |
| `mask_url` | string | No | — | PNG mask URL for partial inpainting. Only supported by `gpt-4o-image`. White areas = edit, black areas = keep. |

### Image Models (20)

#### Stable

| Model | Description | Key capability |
|-------|-------------|----------------|
| `gpt-image-1.5` *(default)* | OpenAI GPT Image 1.5 — latest generation | text-to-image, image-editing |
| `gpt-image-1` | OpenAI GPT Image 1 — high-quality generation | text-to-image, image-editing |
| `gemini-3.1-flash-image-preview` | Nano Banana 2 — Google Gemini 3.1 Flash | text-to-image, image-editing, fast |
| `gemini-3-pro-image-preview` | Google Gemini 3 Pro — image generation preview | text-to-image |
| `z-image-turbo` | Z-Image Turbo — fastest generation | text-to-image, ultra-fast |
| `doubao-seedream-4.5` | ByteDance Seedream 4.5 — photorealistic | text-to-image, photorealistic |
| `doubao-seedream-4.0` | ByteDance Seedream 4.0 — high-quality | text-to-image |
| `doubao-seedream-3.0-t2i` | ByteDance Seedream 3.0 — text-to-image | text-to-image |
| `doubao-seededit-4.0-i2i` | ByteDance Seededit 4.0 — image-to-image editing | image-editing |
| `doubao-seededit-3.0-i2i` | ByteDance Seededit 3.0 — image-to-image editing | image-editing |
| `qwen-image-edit` | Alibaba Qwen — instruction-based editing | image-editing, instruction-based |
| `qwen-image-edit-plus` | Alibaba Qwen Plus — advanced editing | image-editing, instruction-based |
| `wan2.5-t2i-preview` | Alibaba WAN 2.5 — text-to-image preview | text-to-image |
| `wan2.5-i2i-preview` | Alibaba WAN 2.5 — image-to-image preview | image-editing |
| `wan2.5-text-to-image` | Alibaba WAN 2.5 — text-to-image | text-to-image |
| `wan2.5-image-to-image` | Alibaba WAN 2.5 — image-to-image | image-editing |

#### Beta

| Model | Description | Key capability |
|-------|-------------|----------------|
| `gpt-image-1.5-lite` [BETA] | OpenAI GPT Image 1.5 Lite — fast lightweight | text-to-image, fast |
| `gpt-4o-image` [BETA] | OpenAI GPT-4o Image — best prompt understanding + editing | text-to-image, image-editing, best-quality |
| `gemini-2.5-flash-image` [BETA] | Google Gemini 2.5 Flash — fast image generation | text-to-image, fast |
| `nano-banana-2-lite` [BETA] | Nano Banana 2 Lite — versatile general-purpose | text-to-image, fast |

---

## check_task

**Endpoint:** `GET /v1/tasks/{task_id}`

### Response Fields

| Field | Type | Description |
|-------|------|-------------|
| `id` | string | Task ID |
| `model` | string | Model used for generation |
| `status` | enum | `pending` / `processing` / `completed` / `failed` |
| `progress` | integer | Progress percentage (0–100) |
| `results[]` | string[] | Direct result URLs — image download links |
| `result_data[].image_url` | string | Image download URL |
| `task_info.estimated_time` | integer | Estimated seconds remaining |
| `task_info.can_cancel` | boolean | Whether the task can be cancelled |
| `usage.credits_reserved` | number | Credits charged for this task |
| `usage.billing_rule` | string | Billing rule applied |
| `error.code` | string | Error code (only when `status: "failed"`) |
| `error.message` | string | Error description (only when `status: "failed"`) |
| `error.type` | string | Error type (only when `status: "failed"`) |

**Note:** All result URLs expire in **24 hours**. Download promptly.

### Status Values

| Status | Meaning | Action |
|--------|---------|--------|
| `pending` | Queued, not started | Continue polling |
| `processing` | Generation in progress | Continue polling, report `progress` |
| `completed` | Generation finished | Extract URLs from `results[]` or `result_data[]` |
| `failed` | Generation failed | Read `error.code` + `error.message`, surface to user |

---

## File Management API

**Base URL:** `https://files-api.evolink.ai` (different from generation API)
**Auth:** `Authorization: Bearer {EVOLINK_API_KEY}` (same API key)

All file endpoints are **synchronous** — no task polling needed.

### upload_file

Three upload methods available:

| Method | Endpoint | Content-Type | Use when |
|--------|----------|-------------|----------|
| Base64 | `POST /api/v1/files/upload/base64` | `application/json` | Have base64 data |
| Stream | `POST /api/v1/files/upload/stream` | `multipart/form-data` | Have a local file |
| URL | `POST /api/v1/files/upload/url` | `application/json` | Have a remote URL |

**MCP Tool Parameters:**

| Parameter | Type | Required | Description |
|-----------|------|----------|-------------|
| `file_path` | string | One of three | Local file path. Uses stream upload internally. |
| `base64_data` | string | One of three | Base64-encoded data (raw or Data URL format). |
| `file_url` | string | One of three | Remote URL. Server downloads and stores it. |
| `upload_path` | string | No | Server-side subdirectory for organizing uploads. |
| `file_name` | string | No | Custom file name. |

**Response Fields:**

| Field | Type | Description |
|-------|------|-------------|
| `data.file_id` | string | Unique file identifier (use for delete) |
| `data.file_name` | string | Stored file name |
| `data.original_name` | string | Original file name |
| `data.file_size` | number | File size in bytes |
| `data.mime_type` | string | MIME type (e.g., `image/jpeg`) |
| `data.file_url` | string | Public URL — use as `image_urls` input |
| `data.download_url` | string | Direct download URL |
| `data.upload_time` | string | Upload timestamp |
| `data.expires_at` | string | Expiration timestamp |

### delete_file

**Endpoint:** `DELETE /api/v1/files/{file_id}`

| Parameter | Type | Required | Description |
|-----------|------|----------|-------------|
| `file_id` | string | Yes | File ID to delete |

### list_files

**Endpoints:** `GET /api/v1/files/list` + `GET /api/v1/files/quota` (called together)

| Parameter | Type | Required | Description |
|-----------|------|----------|-------------|
| `page` | integer | No | Page number (default: 1) |
| `page_size` | integer | No | Files per page (default: 20, max: 100) |

### File Constraints

- **Supported formats:** Images only — JPEG, PNG, GIF, WebP (4 types)
- **Max file size:** 100MB
- **File expiry:** 72 hours from upload (auto-deleted)
- **File quota:** 100 files (default) / 500 files (VIP)
- **Same-name override:** Uploading a file with an existing name overwrites the old file (may have cache delay)
- **1 file per request**

---

## Polling Strategy

### Recommended Intervals

| Type | Initial wait | Poll interval | Max wait |
|------|-------------|---------------|----------|
| Image | 3s | 3–5s | 5 minutes |

### Algorithm

1. Submit `generate_image` → receive `task_id`
2. Wait 3 seconds (initial delay)
3. Call `check_task` → inspect `status`
4. If `pending` or `processing`: wait 3–5 seconds, repeat step 3
5. If `completed`: extract URLs from `results[]` (array of strings) or `result_data[]` (objects with typed fields)
6. If `failed`: read `error.code` and `error.message`, surface to user with actionable suggestion

### Timeout Handling

After 5 minutes, inform the user:
*"This is taking longer than expected. The task ID is `{task_id}` — you can check it again later."*

---

## Error Codes

### HTTP Status Codes

| Code | Meaning | Resolution |
|------|---------|------------|
| 400 | Bad request — invalid params or content blocked | Check required fields; revise prompt |
| 401 | Invalid or missing API key | Verify `EVOLINK_API_KEY` at evolink.ai/dashboard/keys |
| 402 | Insufficient credits | Top up at evolink.ai/dashboard/billing |
| 403 | Access denied | Check account permissions |
| 404 | Resource not found | Verify `task_id` is correct |
| 413 | Payload too large | Compress images to under 4MB |
| 429 | Rate limit exceeded | Wait 30–60 seconds, then retry |
| 500 | Internal server error | Retry after 1 minute |
| 502 | Upstream unavailable | Retry after 1 minute |
| 503 | Service unavailable | Retry after 1–2 minutes |

### Task Error Codes (from check_task when status is "failed")

| Code | Retryable | Description | Resolution |
|------|-----------|-------------|------------|
| `content_policy_violation` | No | Prompt blocked by safety filter | Rephrase; avoid explicit violence, NSFW, real person names |
| `invalid_parameters` | No | Invalid parameter values | Check param values against model limits |
| `image_dimension_mismatch` | No | Image dimensions don't match request | Resize image to match requested aspect ratio |
| `image_processing_error` | No | Failed to process input image | Check format (JPG/PNG/WebP), size (<10MB), URL accessibility |
| `model_unavailable` | No | Model temporarily offline | Call `list_models` to find available alternatives |
| `generation_timeout` | Yes | Generation exceeded time limit | Retry; simplify prompt or lower resolution if repeated |
| `quota_exceeded` | Yes | Account credits depleted | Wait, then retry. Top up at evolink.ai/dashboard/billing |
| `resource_exhausted` | Yes | Server resources temporarily full | Wait 30–60 seconds and retry |
| `service_error` | Yes | Internal service error | Retry after 1 minute |
| `generation_failed_no_content` | Yes | Generation produced no output | Modify prompt and retry |
| `upstream_error` | Yes | Upstream provider error | Retry after 1 minute |
| `rate_limited` | Yes | Rate limit at task level | Wait 30 seconds and retry |
| `unknown_error` | Yes | Unclassified error | Retry; contact support if persistent |

### File API Error Codes

| Code | Description | Resolution |
|------|-------------|------------|
| 400 | Bad request | Check parameters |
| 401 | Unauthorized | Verify API key |
| 403 | Forbidden | Check account permissions |
| 404 | File not found | Verify file_id |
| 40001 | File too large | Compress to under 100MB |
| 40002 | File type not allowed | Check supported formats (JPEG/PNG/GIF/WebP only) |
| 40003 | Quota exceeded | Delete files with `delete_file` to free quota |
| 40004 | URL download failed | Verify the source URL is accessible |
| 500 | Server error | Retry |
| 50001 | Storage service error | Retry after 1 minute |
