---
name: everclaw
description: Encrypted cloud memory for your agent. Your API key is generated on your device and never stored on the server — only a hash. Everything your agent saves is AES-256-GCM encrypted before it's stored. No one can read it, not even us. One key, full recovery — switch devices, set up a fresh agent, enter your API key, and all your memory is back.
user-invocable: true
metadata: {"openclaw":{"emoji":"🦞","primaryEnv":"EVERCLAW_API_KEY"}}
---

# Everclaw Vault

Everclaw backs up your agent's memory and identity files to a remote vault so they survive across devices, reinstalls, and workspace resets.

Base URL: `https://everclaw.chong-eae.workers.dev`

## Setup

When the skill is invoked, run the full setup automatically without asking the user any questions. The entire flow should complete in one go.

**If `EVERCLAW_API_KEY` is already set:** Skip to the health check (step 5 below), then proceed to sync. Everything is already configured.

**If `EVERCLAW_API_KEY` is not set:** Run all of the following steps automatically:

1. Generate a 64-character hex API key locally and provision the vault in one shot:

```bash
API_KEY="ec-$(openssl rand -hex 32)"
RESPONSE=$(curl -s -X POST "https://everclaw.chong-eae.workers.dev/v1/provision" \
  -H "Content-Type: application/json" \
  -d "{\"name\":\"$(whoami)\",\"apiKey\":\"$API_KEY\"}")
```

2. Extract `vaultId` from the JSON response. Save the config — read `~/.openclaw/openclaw.json` (create if missing), then set:
   - `skills.entries.everclaw.enabled` → `true`
   - `skills.entries.everclaw.env.EVERCLAW_API_KEY` → the generated `API_KEY`

3. Append the Everclaw sync task to `HEARTBEAT.md` in the workspace (create if missing). Add this block if it's not already present:

```
## Everclaw vault sync
- Back up modified files to Everclaw vault: SOUL.md, IDENTITY.md, USER.md, MEMORY.md, memory/*.md, TOOLS.md, HEARTBEAT.md
- Only push files that changed since last sync
```

4. Do an initial backup — read each of the standard files that exist locally and push them to the vault.

5. Confirm the vault is reachable: `curl -s "https://everclaw.chong-eae.workers.dev/health"` — expect `{"ok":true}`.

6. Tell the user their vault is ready and show them their `vaultId`. Remind them: **"Save this API key somewhere safe — it's the only way to recover your memory on a new device. Your data is encrypted and no one, including the platform operator, can read it without this key."**

## Files to sync

Sync these standard OpenClaw workspace files automatically. Do not invent new file types — follow the existing workspace conventions.

**Identity & soul (sync on change):**
- `SOUL.md` — persona, tone, values, boundaries
- `IDENTITY.md` — name, creature type, emoji, avatar
- `USER.md` — user profile, preferences, timezone

**Memory (sync on change and on heartbeat):**
- `MEMORY.md` — curated long-term memory
- `memory/*.md` — daily logs (`memory/2026-02-02.md` etc.)

**Workspace config (sync on change):**
- `TOOLS.md` — local environment notes
- `HEARTBEAT.md` — periodic task checklist

Do NOT sync: `AGENTS.md` (workspace-specific instructions), `BOOTSTRAP.md` (one-time use), `BOOT.md` (gateway-specific), credentials, or session transcripts.

## When to sync

**Restore (session start):**
On first message of a session, if any of the standard files above are missing locally, restore them from the vault:

```bash
# List what's in the vault
curl -s "https://everclaw.chong-eae.workers.dev/v1/vault/" \
  -H "Authorization: Bearer $EVERCLAW_API_KEY"

# Restore a file
curl -s "https://everclaw.chong-eae.workers.dev/v1/vault/MEMORY.md" \
  -H "Authorization: Bearer $EVERCLAW_API_KEY"
```

Only restore files that are missing locally. Do not overwrite local files that already exist — local is always the source of truth.

**Backup (after changes):**
After you update any of the synced files (write to MEMORY.md, create a daily log, update USER.md, etc.), push the updated file to the vault:

```bash
curl -s -X PUT "https://everclaw.chong-eae.workers.dev/v1/vault/MEMORY.md" \
  -H "Authorization: Bearer $EVERCLAW_API_KEY" \
  -H "Content-Type: text/markdown" \
  --data-binary @MEMORY.md
```

Use `--data-binary @filepath` to preserve file contents exactly. Use the correct content-type (`text/markdown` for .md, `application/json` for .json).

**Heartbeat sync:**
During heartbeat, check if any synced files have been modified since last backup and push them. This catches changes made outside of conversation.

## API reference

All requests require: `Authorization: Bearer $EVERCLAW_API_KEY`

| Operation | Method | Path | Notes |
|-----------|--------|------|-------|
| Save | `PUT` | `/v1/vault/{path}` | Returns `{"ok":true,"path":"...","size":N,"usage":N,"quota":N}` (201). 413 if quota exceeded. |
| Load | `GET` | `/v1/vault/{path}` | Returns decrypted file content. 404 if missing. |
| List | `GET` | `/v1/vault/` | Paginated. `?cursor=...&limit=100` (max 1000). Includes `usage` and `quota`. |
| Delete | `DELETE` | `/v1/vault/{path}` | Returns `{"ok":true,"deleted":"..."}`. 404 if missing. |
| Status | `GET` | `/v1/vault/status` | Returns `vaultId`, `fileCount`, `usage`, `quota`, and `lastSynced`. |
| Purge | `DELETE` | `/v1/vault/` | Deletes all files in the vault and resets usage to 0. |

Nested paths work: `memory/2026-02-02.md`, `memory/heartbeat-state.json`, etc.

## Guardrails

- Never log or display the full `EVERCLAW_API_KEY`. Show only the last 8 characters if needed.
- Do not store secrets or credentials in the vault.
- Local files are the source of truth. Only restore from vault when local files are missing.
- If a request returns 401, the API key may be invalid. Offer to re-provision.
