# Listing Audit Playbook - Etsy

Use this workflow when a user asks why a listing is underperforming.

## 1. Intake Snapshot

Collect a compact baseline before suggesting edits:
- Product category and buyer segment
- Current title, first image, and price point
- Recent views, favorites, carts, and conversions
- Shipping ETA and return policy summary

## 2. Diagnose by Funnel Stage

Evaluate each stage separately to avoid random changes:

| Stage | Signal | Common Failure |
|-------|--------|----------------|
| Search visibility | Low impressions/views | Weak keyword intent match |
| Click-through | Low visits per impression | Title opening or thumbnail mismatch |
| Consideration | Low favorites/carts | Offer not clear vs alternatives |
| Conversion | Low orders per visit | Price, shipping, trust, or policy friction |

## 3. Prioritize Fixes by Expected Impact

Use this order for most Etsy listings:
1. Main image and title opening clarity
2. Shipping promise and processing transparency
3. Price architecture and bundle logic
4. Description opening and objection handling
5. Supporting tags and long-tail coverage

## 4. Build One-Variable Experiments

Keep experiments auditable:
- Change exactly one major variable per cycle
- Define minimum window (7 to 14 days unless traffic is very high)
- Track views, favorites, carts, conversion, and revenue per visit

## 5. Decide With Rules, Not Intuition

- Keep change if conversion improves with stable margin
- Revert if traffic increases but conversion collapses
- Iterate if metrics move in opposite directions and bottleneck shifts

## 6. Escalation Triggers

Recommend deeper review when:
- Conversion remains flat after two clean experiments
- Listing metrics are unstable due to stockouts or shipping delays
- Policy risk appears in title, tags, or claims
