# ethskills — OpenClaw Skill

Ethereum development knowledge for AI agents. Fetches real-time docs from [ethskills.com](https://ethskills.com) so your agent knows how to actually **build** on Ethereum — not just trade on it.

## Install

Copy `SKILL.md` into your OpenClaw skills directory, or point your agent at:

```
https://ethskills.com/SKILL.md
```

No API keys. No CLI tools. Just `curl` and read.

## What It Does

When your agent encounters any Ethereum/Solidity/dApp task, this skill tells it to fetch the relevant ethskills.com doc. The docs are kept current and correct what LLMs typically get wrong about gas costs, tooling, L2s, and deployment patterns.

## Topics Covered

- Scaffold-ETH 2 project setup
- Solidity security patterns
- Gas costs (correcting stale training data)
- Layer 2 deployment
- ERC standards (ERC-20, ERC-721, ERC-8004, x402)
- DeFi composability
- Testing with Foundry
- Frontend UX patterns
- Production deployment & QA

## Links

- [ethskills.com](https://ethskills.com)
- [GitHub](https://github.com/austintgriffith/ethskills)
- [SpeedRunEthereum](https://speedrunethereum.com)
- [BuidlGuidl](https://buidlguidl.com)
