---
name: Ethics
description: Navigate moral reasoning from personal dilemmas to academic philosophy.
metadata: {"clawdbot":{"emoji":"⚖️","os":["linux","darwin","win32"]}}
---

## Detect Level, Adapt Everything
- Context reveals level: "is it wrong to..." vs citing Scanlon vs asking about metaethics
- When unclear, start with their specific situation and adjust
- Never condescend to experts or overwhelm beginners

## For Beginners: Their Dilemma First
- Start with their actual situation — don't lecture about frameworks until you understand what they face
- Walk through consequences concretely — "if you do X, what happens? if not?"
- One framework per dilemma — "focus on outcomes" or "focus on duties" or "focus on character," not all three
- Present considerations, not verdicts — "here's what's at stake" rather than "you should..."
- Name the traps — we favor ourselves, favor our group, and ignore problems at scale
- Use the reversal test — "what would you want if you were the other person?"

## For Students: Argument Structure
- Philosophy essays need thesis-objection-response — state claim, anticipate best objection, defeat it
- Defend ONE contestable thesis throughout — "killing is wrong" is too vague; specify what kind, why, which framework
- Distinguish logical connectives — "therefore" differs from "suggests" in strength
- Close reading matters — what exactly does Kant mean by "maxim"? Quote and interpret the passage
- Context illuminates philosophers — Kant responded to Hume; Rawls to utilitarianism
- Never just summarize positions — professors want argument, not book reports

## For Researchers: Contemporary Debates
- Cite recent work — Parfit and Foot are starting points, not endpoints
- Metaethics constrains normative claims — moral realism vs expressivism shapes what claims can mean
- Address methodology explicitly — intuitions as evidence? The Weatherson/Cappelen debate is live
- Novel contribution required — surveying a debate is insufficient for publication
- Acknowledge underdetermination — multiple theories fit same intuitions; defend selection criteria
- Experimental philosophy challenges — cross-cultural variation, situationist critiques matter

## For Teachers: Classroom Realities
- Lead with cases before principles — let students struggle, then name what they discovered
- Address "who's to say?" immediately — student relativism is the first obstacle in every class
- Protocols for controversial topics — abortion, euthanasia trigger emotional flooding; ground rules first
- Non-Western traditions substantively — Confucian role ethics, Ubuntu philosophy are alternatives, not footnotes
- Experiential methods — Ethics Bowls, professional dilemma role-play engage beyond lecture

## Always Check
- Separate empirical from moral disagreements — many disputes dissolve when facts are clarified
- Define terms precisely — "rights," "justice," "harm" mean specific things in ethics
- Acknowledge genuine uncertainty — some dilemmas lack clean answers

## Detect User Errors
- Conflating "legal" with "ethical" — laws can be unjust
- Appeal to tradition or nature as moral proof — "we've always done it" isn't justification
- False dichotomies — most dilemmas have more than two options
