---
name: ethermail
description: Access Web3 email via EtherMail using WalletConnect. Use when you need to check or send emails with your Ethereum wallet address, receive notifications from Web3 services, or communicate with other AI agents via decentralized email.
---

# EtherMail (Web3 Email)

Access email using your Ethereum wallet address. No email/password needed — just sign with your wallet!

## 🚀 Quick Start

**Easiest way:** Use the Telegram Mini App!
👉 [Open EtherMail on Telegram](https://t.me/ethermailappbot/app?startapp=afid_6986e9a5c5a97b905a78c390)

## Prerequisites

1. **WalletConnect connector** — Use the `walletconnect-agent` skill or your own WalletConnect setup
2. **Browser automation** — Clawdbot browser tool or Puppeteer
3. **EVM wallet** — Any Ethereum-compatible address

## Your EtherMail Address

Your email is automatically derived from your wallet:
```
<your-wallet-address>@ethermail.io
```
Example: `0xYourWalletAddress@ethermail.io`

You can also set up custom aliases like `myname@ethermail.io` in account settings.

---

## Access Methods

### Method 1: Telegram Mini App (Recommended)

The easiest way to access EtherMail:
1. Open: https://t.me/ethermailappbot/app?startapp=afid_6986e9a5c5a97b905a78c390
2. Connect your wallet via WalletConnect
3. Read and send emails directly in Telegram!

### Method 2: Web Browser + WalletConnect

#### Step 1: Navigate to Login Page

```bash
browser action=navigate profile=clawd targetUrl="https://ethermail.io/accounts/login"
```

#### Step 2: Click Wallet Login

Find and click the "Sign in with Wallet" button to trigger WalletConnect modal.

#### Step 3: Extract WalletConnect URI from Shadow DOM

EtherMail embeds WalletConnect in Shadow DOM. Use this script to extract the URI:

```javascript
// Run in browser console or via browser action=act evaluate
function findWalletConnectURI() {
  function searchShadow(root, depth = 0) {
    if (depth > 5) return null;
    const elements = root.querySelectorAll('*');
    for (const el of elements) {
      if (el.shadowRoot) {
        const html = el.shadowRoot.innerHTML;
        const match = html.match(/wc:[a-f0-9]+@2\?[^"'<>\s]+/);
        if (match) return match[0];
        const found = searchShadow(el.shadowRoot, depth + 1);
        if (found) return found;
      }
    }
    return null;
  }
  return searchShadow(document);
}
findWalletConnectURI();
```

Or use the bundled script:
```bash
# Returns: wc:abc123...@2?relay-protocol=irn&symKey=xyz...
node scripts/extract-wc-uri.js
```

#### Step 4: Connect with WalletConnect

Use the `walletconnect-agent` skill (install from ClawdHub):

```bash
# Install walletconnect-agent skill first
clawdhub install walletconnect-agent

# Then use its wc-connect.js script
cd ~/clawd/skills/walletconnect-agent
export PRIVATE_KEY="0x..."
node scripts/wc-connect.js "<WC_URI>"
```

The connector will automatically sign the `personal_sign` request, completing login.

> ⚠️ **Security Note:** Always use the official `walletconnect-agent` skill from ClawdHub.
> Do not use untrusted third-party WalletConnect scripts.

#### Step 5: Access Inbox

After successful login, the browser redirects to your inbox. Use browser automation to:
- Read emails
- Compose new messages
- Check notifications

---

## Shadow DOM Extraction Script

For browser automation, use `scripts/extract-wc-uri.js`:

```bash
# Usage with Puppeteer
node scripts/extract-wc-uri.js --url "https://ethermail.io/accounts/login"
```

---

## Use Cases

1. **Agent-to-Agent Communication** — Receive emails from other AI agents
2. **Web3 Notifications** — NFT drops, DAO votes, DeFi alerts
3. **Decentralized Identity** — Email tied to your on-chain identity
4. **Backup Communication** — When other channels fail
5. **Earn Rewards** — Get paid in $EMT tokens for reading promotional emails

---

## Troubleshooting

### Can't find WalletConnect URI
- Shadow DOM search needs sufficient depth (try depth > 5)
- URI only appears after WalletConnect modal is fully loaded
- Some browsers block Shadow DOM access — use headless Chromium

### URI expired
- WalletConnect URIs expire in ~5 minutes
- Close modal and reopen to get fresh URI

### Login fails
- Ensure wallet address matches the expected signer
- Check that wc-connect.js supports `personal_sign`
- Verify you're on EVM-compatible network

### CAPTCHA blocking login
- EtherMail uses Turnstile CAPTCHA on the web
- Use the Telegram Mini App instead for easier access

---

## Security Notes

- ⚠️ Never commit private keys
- Store credentials in environment variables or secure files
- EtherMail only requires message signing (no transaction needed for login)
- Use dedicated wallet for agent operations
- Use official `walletconnect-agent` skill from ClawdHub for WalletConnect integration
- Browser automation runs with Puppeteer sandbox enabled for security isolation

---

## Changelog

### v1.1.0 (2026-02-08) - Security Update
- 🔐 Removed `--no-sandbox` flag from Puppeteer for better security isolation
- 📝 Clarified to use official `walletconnect-agent` skill from ClawdHub
- 📝 Added supply chain security notes

### v1.0.0
- 🎉 Initial release

---

## Links

- **Telegram App:** https://t.me/ethermailappbot/app?startapp=afid_6986e9a5c5a97b905a78c390
- **Website:** https://ethermail.io
- **Mobile App:** Available on iOS and Android
