# Etherlink Network Reference

## Mainnet

| Property | Value |
|----------|-------|
| Network Name | Etherlink Mainnet |
| Chain ID | 42793 (0xa729) |
| RPC URL | https://node.mainnet.etherlink.com |
| Block Explorer | https://explorer.etherlink.com |
| Currency Symbol | XTZ |
| Currency Decimals | 18 |

### Add to MetaMask (Mainnet)
```
Network Name: Etherlink Mainnet
RPC URL: https://node.mainnet.etherlink.com
Chain ID: 42793
Currency Symbol: XTZ
Block Explorer: https://explorer.etherlink.com
```

## Shadownet Testnet

| Property | Value |
|----------|-------|
| Network Name | Etherlink Shadownet Testnet |
| Chain ID | 127823 (0x1f34f) |
| RPC URL | https://node.shadownet.etherlink.com |
| Block Explorer | https://shadownet.explorer.etherlink.com |
| Faucet | https://shadownet.faucet.etherlink.com |
| Currency Symbol | XTZ |
| Currency Decimals | 18 |

### Add to MetaMask (Shadownet)
```
Network Name: Etherlink Shadownet
RPC URL: https://node.shadownet.etherlink.com
Chain ID: 127823
Currency Symbol: XTZ
Block Explorer: https://shadownet.explorer.etherlink.com
```

## Network Aliases

The MCP server accepts these network identifiers:

### Mainnet
- `etherlink`
- `etherlink-mainnet`
- `etherlinkmainnet`
- `42793`

### Shadownet Testnet
- `etherlink-shadownet`
- `etherlinkshadownet`
- `etherlink-testnet`
- `etherlinktestnet`
- `shadownet`
- `127823`

## Rate Limits

Public RPC endpoints are rate-limited:
- **1000 requests per minute** per IP

For higher throughput, consider:
1. Running your own Etherlink node
2. Using a dedicated RPC provider
