---
name: etherlink
description: Etherlink blockchain interaction - EVM-compatible L2 on Tezos. Supports mainnet and shadownet testnet via MCP server. Use for balance checks, transactions, smart contracts, and token operations on Etherlink.
tags: [blockchain, evm, tezos, l2, web3, etherlink, mcp]
version: 1.0.0
---

# Etherlink Skill

Interact with [Etherlink](https://etherlink.com), an EVM-compatible L2 built on Tezos.

## Quick Start

### 1. Configure MCP Server

Add to your Claude/MCP config:

```json
{
  "mcpServers": {
    "etherlink": {
      "command": "bun",
      "args": ["run", "/path/to/etherlink-mcp-server/src/index.ts"],
      "env": {
        "EVM_PRIVATE_KEY": "your-private-key-here"
      }
    }
  }
}
```

### 2. Select Network

Use network name or chain ID:
- **Mainnet**: `etherlink` or `42793`
- **Testnet**: `etherlink-shadownet` or `127823`

## Networks

| Network | Chain ID | RPC | Explorer |
|---------|----------|-----|----------|
| Etherlink Mainnet | 42793 | https://node.mainnet.etherlink.com | https://explorer.etherlink.com |
| Etherlink Shadownet | 127823 | https://node.shadownet.etherlink.com | https://shadownet.explorer.etherlink.com |

**Native Currency**: XTZ (18 decimals)

## Common Operations

### Check Balance
```
Get balance for 0x... on etherlink
```

### Send Transaction
```
Send 0.1 XTZ to 0x... on etherlink
```

### Read Contract
```
Call balanceOf on contract 0x... for address 0x... on etherlink
```

### Get Block Info
```
Get latest block on etherlink
```

## Etherlink-Specific Notes

### Key Differences

1. **Native Currency**: XTZ (Tez), not ETH
2. **No EIP-1559**: Fee market not yet implemented - use legacy gas pricing
3. **Block Hashes**: Computed differently (can't verify from header alone)
4. **Rate Limits**: Public RPC limited to 1000 req/min

### Supported Endpoints
- ✅ eth_blockNumber, eth_chainId, eth_getBalance
- ✅ eth_call, eth_estimateGas, eth_gasPrice
- ✅ eth_sendRawTransaction, eth_getLogs
- ✅ debug_traceTransaction
- ❌ eth_subscribe (experimental only)
- ❌ Filter endpoints (eth_newFilter, etc.)

### Tezos L1 Bridge
Etherlink bridges to Tezos L1 for deposits/withdrawals. Bridge operations require Tezos tooling. See [Etherlink Docs](https://docs.etherlink.com/building-on-etherlink/bridging) for details.

## Testnet Faucet

Get testnet XTZ: https://shadownet.faucet.etherlink.com

## Troubleshooting

**"Unsupported network"**: Use correct network name (`etherlink`, `etherlink-shadownet`) or chain ID.

**Rate limited**: Public RPC has 1000 req/min limit. For production, run your own node.

**Transaction failing**: No EIP-1559 - don't set `maxFeePerGas`/`maxPriorityFeePerGas`.

## Resources

- [Etherlink Docs](https://docs.etherlink.com/)
- [Block Explorer](https://explorer.etherlink.com)
- [Shadownet Explorer](https://shadownet.explorer.etherlink.com)
- [Faucet](https://shadownet.faucet.etherlink.com)
