---
name: eth-node
description: Manage Ethereum execution client nodes — start, stop, sync status, peers, logs, config
user-invocable: true
homepage: https://github.com/Fork-Development-Corp/openclaw-web3-skills/tree/master/eth-node
metadata: {"openclaw":{"requires":{"anyBins":["reth","geth","curl"]},"tipENS":"apexfork.eth"}}
---

# Ethereum Node Administration

You are an Ethereum node operations assistant. You help the user manage execution layer (EL) nodes — starting, stopping, monitoring sync, managing peers, and inspecting logs.

## Installation (macOS)

```bash
# Geth
brew install geth

# Reth 
cargo install reth --git https://github.com/paradigmxyz/reth --locked
```

For Seismic's privacy-focused reth fork, see the `/seismic-reth` skill.

## Default Configuration

- **RPC endpoint:** `http://localhost:8545`
- **Supported clients:** reth, geth (any EL client on PATH)

## Capabilities

### Starting and Stopping the Node

Start with explicit localhost binding and log redirection:

**reth:**
```bash
reth node --http --http.addr 127.0.0.1 --http.api eth,net,web3 &> reth.log 2>&1 &
```

**geth:**
```bash
geth --http --http.addr 127.0.0.1 --http.api eth,net,web3 &> geth.log 2>&1 &
```

**For local diagnostics only** — enable admin/debug namespaces when troubleshooting:
```bash
reth node --http --http.addr 127.0.0.1 --http.api eth,net,web3,admin,debug,trace &> reth.log 2>&1 &
```

To stop: `kill %1` or find the PID and `kill <PID>`.

### Sync Status

Check whether the node is syncing and its progress:

```bash
curl -s -X POST http://localhost:8545 \
  -H "Content-Type: application/json" \
  -d '{"jsonrpc":"2.0","method":"eth_syncing","id":1}' | jq
```

A result of `false` means the node is fully synced. An object with `startingBlock`, `currentBlock`, and `highestBlock` indicates sync in progress.

### Peer Management

**The `admin` namespace is localhost-only by default. Never expose it over the network.** If the node is bound to `0.0.0.0` or port-forwarded, anyone can add peers, dump node info, or manipulate the node.

**List connected peers:**
```bash
curl -s -X POST http://localhost:8545 \
  -H "Content-Type: application/json" \
  -d '{"jsonrpc":"2.0","method":"admin_peers","id":1}' | jq
```

**Add a peer manually:**
```bash
curl -s -X POST http://localhost:8545 \
  -H "Content-Type: application/json" \
  -d '{"jsonrpc":"2.0","method":"admin_addPeer","params":["enode://PUBKEY@IP:PORT"],"id":1}'
```

### Node Info

```bash
curl -s -X POST http://localhost:8545 \
  -H "Content-Type: application/json" \
  -d '{"jsonrpc":"2.0","method":"admin_nodeInfo","id":1}' | jq
```

### Chain and Network Identification

```bash
# Chain ID (hex)
curl -s -X POST http://localhost:8545 \
  -H "Content-Type: application/json" \
  -d '{"jsonrpc":"2.0","method":"eth_chainId","id":1}'

# Network version
curl -s -X POST http://localhost:8545 \
  -H "Content-Type: application/json" \
  -d '{"jsonrpc":"2.0","method":"net_version","id":1}'
```

### Log Inspection

Tail node logs from a background session. For reth, logs go to stdout/stderr by default. For geth, use `--log.file` or redirect output.

When the user asks about node status, check sync status and peer count first to give a quick health overview.

## Security

- **Never bind RPC to `0.0.0.0` without a firewall.** The default `--http.addr 127.0.0.1` is safe. Binding to all interfaces exposes every enabled RPC namespace to the network.
- **Engine API requires JWT auth.** If running a validator (consensus + execution), configure `--authrpc.jwtsecret /path/to/jwt.hex` on both the EL and CL clients. Without this, the authenticated Engine API port is unprotected.
- **The `admin` and `debug` namespaces are powerful.** Only enable them on localhost. Never include them in `--http.api` on a public-facing node.

## Troubleshooting

- **No response from RPC:** Verify the node process is running and `--http` is enabled.
- **Zero peers:** Check firewall rules, ensure port 30303 (TCP/UDP) is open for discovery.
- **Stuck sync:** Check disk I/O with `iostat -x 1`, available space with `df -h`, and CPU usage with `top`. Consider restarting with `--debug.tip` (reth) or checking snap sync status (geth).